/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.tracker;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.map.WorldMapSession;

public class ClientboundTrackedPlayerPacket {
    private final boolean remove;
    private final UUID id;
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation dimension;

    public ClientboundTrackedPlayerPacket(boolean remove, UUID id, double x, double y, double z, ResourceLocation dimension) {
        this.remove = remove;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public void write(FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("r", this.remove);
        nbt.putUUID("i", this.id);
        if (!this.remove) {
            nbt.putDouble("x", this.x);
            nbt.putDouble("y", this.y);
            nbt.putDouble("z", this.z);
            nbt.putString("d", this.dimension.toString());
        }
        buffer.writeNbt(nbt);
    }

    public static ClientboundTrackedPlayerPacket read(FriendlyByteBuf buffer) {
        CompoundTag nbt = buffer.readAnySizeNbt();
        boolean remove = nbt.getBoolean("r");
        UUID id = nbt.getUUID("i");
        double x = remove ? 0.0 : nbt.getDouble("x");
        double y = remove ? 0.0 : nbt.getDouble("y");
        double z = remove ? 0.0 : nbt.getDouble("z");
        String dimensionString = remove ? null : nbt.getString("d");
        ResourceLocation dimension = dimensionString == null ? null : new ResourceLocation(dimensionString);
        return new ClientboundTrackedPlayerPacket(remove, id, x, y, z, dimension);
    }

    public static class Handler
    implements Consumer<ClientboundTrackedPlayerPacket> {
        @Override
        public void accept(ClientboundTrackedPlayerPacket t) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            if (t.remove) {
                session.getMapProcessor().getClientSyncedTrackedPlayerManager().remove(t.id);
                return;
            }
            session.getMapProcessor().getClientSyncedTrackedPlayerManager().update(t.id, t.x, t.y, t.z, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)t.dimension));
        }
    }
}

