/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.Config;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.gui.GuiMap;
import xaero.map.gui.TooltipButton;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private AbstractWidget caveModeStartSlider;
    private EditBox caveModeStartField;
    private boolean shouldUpdateSlider;

    public void onInit(GuiMap screen, MapProcessor mapProcessor) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = mapProcessor.getMapWorld().getFutureDimension();
        boolean bl = this.enabled = this.enabled && this.dimension != null && WorldMapClientConfigUtils.getEffectiveCaveModeAllowed();
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            Tooltip caveModeTypeButtonTooltip = new Tooltip("gui.xaero_wm_box_cave_mode_type");
            screen.addButton(new TooltipButton(20, screen.height - 62, 150, 20, this.getCaveModeTypeButtonMessage(), b -> this.onCaveModeTypeButton(b, screen), () -> caveModeTypeButtonTooltip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(Button b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.setMessage(this.getCaveModeTypeButtonMessage());
    }

    private EditBox createField(GuiMap screen) {
        EditBox field = new EditBox(Minecraft.getInstance().font, 172, screen.height - 40, 50, 20, (Component)Component.translatable((String)"gui.xaero_wm_cave_mode_start"));
        field.setMaxLength(7);
        int initialCaveModeStart = this.getCaveStart();
        field.setValue((String)(initialCaveModeStart == Integer.MAX_VALUE ? "" : "" + initialCaveModeStart));
        field.setResponder(text -> {
            try {
                this.setCaveStart(text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text));
                this.shouldUpdateSlider = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        return field;
    }

    private int getCaveStart() {
        Config primaryConfig = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager().getConfig();
        return (Integer)primaryConfig.get(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START);
    }

    private void setCaveStart(int y) {
        Config primaryConfig = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager().getConfig();
        primaryConfig.set(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START, (Object)y);
        WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManagerIO().save();
    }

    private AbstractWidget createSlider(GuiMap screen) {
        MutableComponent displayName = Component.translatable((String)"gui.xaero_wm_cave_mode_start");
        Supplier<Component> labelGetter = () -> GuiCaveModeOptions.lambda$createSlider$3((Component)displayName);
        int initialCaveStart = this.getCaveStart();
        int minY = -64;
        int maxY = 319;
        int minOption = minY - 1;
        int range = maxY - minOption;
        double initialSliderValue = Mth.clamp((double)((double)(initialCaveStart - minOption) / (double)range), (double)0.0, (double)1.0);
        return new XaeroSliderWidget(20, screen.height - 40, 150, 20, labelGetter.get(), initialSliderValue, newSliderValue -> {
            int selectedY = (int)Math.round(newSliderValue * (double)range) + minOption;
            if (selectedY == minOption) {
                selectedY = Integer.MAX_VALUE;
            }
            this.setCaveStart(selectedY);
            screen.onCaveModeStartSet();
        }, labelGetter);
    }

    private void updateField(GuiMap screen) {
        if (this.caveModeStartField == null) {
            this.caveModeStartField = this.createField(screen);
            screen.addButton(this.caveModeStartField);
        } else {
            this.caveModeStartField = this.createField(screen);
            screen.replaceRenderableWidget((AbstractWidget)this.caveModeStartField, (AbstractWidget)this.caveModeStartField);
        }
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.addButton(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceRenderableWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMapClientConfigUtils.getEffectiveCaveModeAllowed() && !this.enabled;
        screen.init(Minecraft.getInstance(), screen.width, screen.height);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.shouldUpdateSlider) {
            this.updateSlider(screen);
            this.shouldUpdateSlider = false;
        }
        if (this.enabled) {
            this.caveModeStartField.setSuggestion(this.caveModeStartField.getValue().isEmpty() ? I18n.get((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]) : "");
            this.caveModeStartField.tick();
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.setFocused(false);
        }
        if (this.caveModeStartSlider != null) {
            this.caveModeStartSlider.setFocused(false);
        }
    }

    private Component getCaveModeTypeButtonMessage() {
        return Component.literal((String)(I18n.get((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.get((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0])));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static /* synthetic */ Component lambda$createSlider$3(Component displayName) {
        return displayName;
    }
}

