/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import java.util.Set;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.server.ServerConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    public void register() {
        ServerPlayerEvents.COPY_FROM.register(this::onPlayerClone);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::onServerStopped);
    }

    private void onPlayerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get(oldPlayer));
    }

    public void onServerStarting(MinecraftServer server) {
        new MineraftServerDataInitializer().init(server);
    }

    public void onServerStopped(MinecraftServer server) {
    }

    public void onPlayerLogIn(class_3222 serverPlayer) {
        WorldMap.messageHandler.sendToPlayer(serverPlayer, (Object)new ClientboundPlayerTrackerResetPacket());
    }

    public void onPlayerWorldJoin(class_3222 player) {
        WorldMap.messageHandler.sendToPlayer(player, (Object)new HandshakePacket());
        ServerConfigManager configManager = WorldMap.INSTANCE.getConfigs().getServerConfigManager();
        ConfigProfile defaultEnforcedProfile = configManager.getDefaultEnforcedProfile();
        boolean caveModeConfig = !Boolean.FALSE.equals(defaultEnforcedProfile.get((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED));
        Set caveModeDimensionsConfig = (Set)defaultEnforcedProfile.get(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        boolean allowOverworldCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(class_1937.field_25179.method_29177()));
        boolean allowNetherCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(class_1937.field_25180.method_29177()));
        WorldMap.messageHandler.sendToPlayer(player, (Object)new ClientboundRulesPacket(allowOverworldCaveModeOnServer, allowNetherCaveModeOnServer));
        Path propertiesPath = player.field_6002.method_8503().method_27050(class_5218.field_24184).getParent().resolve("xaeromap.txt");
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.method_5682());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            if (properties.isUsable()) {
                WorldMap.messageHandler.sendToPlayer(player, (Object)properties);
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.field_13987.method_14367((class_2561)new class_2588("gui.xaero_wm_error_loading_properties"));
        }
    }

    public void handlePlayerTickStart(class_1657 player) {
        if (player instanceof class_3222) {
            WorldMap.serverPlayerTickHandler.tick((class_3222)player);
            return;
        }
        if (WorldMap.events != null) {
            WorldMap.events.handlePlayerTickStart(player);
        }
    }
}

