/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class WorldDataChunkTileEntityLookup {
    private NBTTagList tileEntitiesNbt;
    private Int2ObjectMap<Int2ObjectMap<Int2ObjectMap<NBTTagCompound>>> tileEntities;

    public WorldDataChunkTileEntityLookup(NBTTagList tileEntitiesNbt) {
        this.tileEntitiesNbt = tileEntitiesNbt;
    }

    private void loadIfNeeded() {
        if (this.tileEntities == null) {
            this.tileEntities = new Int2ObjectOpenHashMap();
            this.tileEntitiesNbt.forEach((Consumer)new Consumer<NBTBase>(){

                @Override
                public void accept(NBTBase tag) {
                    if (tag instanceof NBTTagCompound) {
                        Int2ObjectMap byY;
                        NBTTagCompound compoundNbt = (NBTTagCompound)tag;
                        if (!compoundNbt.func_150297_b("x", 99)) {
                            return;
                        }
                        int x = compoundNbt.func_74762_e("x") & 0xF;
                        if (!compoundNbt.func_150297_b("y", 99)) {
                            return;
                        }
                        int y = compoundNbt.func_74762_e("y");
                        if (!compoundNbt.func_150297_b("z", 99)) {
                            return;
                        }
                        int z = compoundNbt.func_74762_e("z") & 0xF;
                        Int2ObjectMap byX = (Int2ObjectMap)WorldDataChunkTileEntityLookup.this.tileEntities.get(x);
                        if (byX == null) {
                            byX = new Int2ObjectOpenHashMap();
                            WorldDataChunkTileEntityLookup.this.tileEntities.put(x, (Object)byX);
                        }
                        if ((byY = (Int2ObjectMap)byX.get(y)) == null) {
                            byY = new Int2ObjectOpenHashMap();
                            byX.put(y, (Object)byY);
                        }
                        byY.put(z, (Object)compoundNbt);
                    }
                }
            });
            this.tileEntitiesNbt = null;
        }
    }

    public NBTTagCompound getTileEntityNbt(int x, int y, int z) {
        this.loadIfNeeded();
        Int2ObjectMap byX = (Int2ObjectMap)this.tileEntities.get(x);
        if (byX == null) {
            return null;
        }
        Int2ObjectMap byY = (Int2ObjectMap)byX.get(y);
        if (byY == null) {
            return null;
        }
        return (NBTTagCompound)byY.get(z);
    }
}

