/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.lang.reflect.Field;
import java.util.Hashtable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.core.XaeroWorldMapCore;

public class BlockStateColorTypeCache {
    private Hashtable<IBlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<IBlockState, Object> defaultColorResolversCache = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private IBlockState grassState = Blocks.GRASS.getDefaultState();
    private IBlockState oakLeavesState = Blocks.LEAVES.getDefaultState();
    private IBlockState waterState = Blocks.WATER.getDefaultState();
    private Field defaultGrassResolverField = ReflectionUtils.getFieldReflection(BiomeColorHelper.class, (String)"GRASS_COLOR", (String)"", (String)"", (String)"field_180291_a");
    private Field defaultFoliageResolverField = ReflectionUtils.getFieldReflection(BiomeColorHelper.class, (String)"FOLIAGE_COLOR", (String)"", (String)"", (String)"field_180289_b");
    private Field defaultWaterResolverField = ReflectionUtils.getFieldReflection(BiomeColorHelper.class, (String)"WATER_COLOR", (String)"", (String)"", (String)"field_180290_c");
    private Object DEFAULT_GRASS_RESOLVER;
    private Object DEFAULT_FOLIAGE_RESOLVER;
    private Object DEFAULT_WATER_RESOLVER;
    private boolean detectionWorks = true;
    private MapWriter mapWriter;

    public void setMapWriter(MapWriter mapWriter) {
        this.mapWriter = mapWriter;
    }

    public void getBlockBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.getMinecraft().isCallingFromMinecraftThread();
        if (colorType == -1 && isRenderThread) {
            boolean detected;
            int stateTint = this.mapWriter.getBlockTintIndex(state);
            Object detectedColorResolver = this.detectionWorks ? XaeroWorldMapCore.detectColorResolver(state, world, pos, stateTint, this.DEFAULT_GRASS_RESOLVER, this.DEFAULT_FOLIAGE_RESOLVER, this.DEFAULT_WATER_RESOLVER) : null;
            boolean bl = detected = detectedColorResolver != null;
            if (!detected) {
                if (state.getBlock() == Blocks.WATER || state.getBlock() == Blocks.FLOWING_WATER) {
                    detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                } else {
                    try {
                        customColour = Minecraft.getMinecraft().getBlockColors().colorMultiplier(state, null, null, stateTint);
                    }
                    catch (Throwable t) {
                        customColour = 0;
                    }
                    if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor) {
                        Material material = state.getMaterial();
                        if (material != null && (material.getMaterialMapColor() == MapColor.GRASS || material.getMaterialMapColor() == MapColor.FOLIAGE || material.getMaterialMapColor() == MapColor.WATER)) {
                            customColour = this.tryGettingColor(state, world, pos);
                            gotFullCC = true;
                            if (material.getMaterialMapColor() == MapColor.GRASS && customColour == this.tryGettingColor(this.grassState, world, pos)) {
                                detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                            } else if (material.getMaterialMapColor() == MapColor.FOLIAGE && customColour == this.tryGettingColor(this.oakLeavesState, world, pos)) {
                                detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                            } else if (material.getMaterialMapColor() == MapColor.WATER && customColour == this.tryGettingColor(this.waterState, world, pos)) {
                                detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                            }
                        }
                    } else if (customColour == this.grassColor) {
                        detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                    } else if (customColour == this.foliageColor) {
                        detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                    }
                }
            }
            if (detectedColorResolver != null) {
                colorType = 1;
                if (detectedColorResolver == this.DEFAULT_FOLIAGE_RESOLVER) {
                    colorType = 2;
                }
                if (!detected) {
                    this.defaultColorResolversCache.put(state, detectedColorResolver);
                }
            } else {
                if (!gotFullCC) {
                    customColour = this.tryGettingColor(state, world, pos);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if (biomeId == -1) {
            if (isRenderThread) {
                biomeId = Biome.getIdForBiome((Biome)world.getBiome(pos));
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        dest[1] = biomeId;
        if (colorType == 3) {
            if (!gotFullCC) {
                customColour = this.tryGettingColor(state, world, pos);
            }
            dest[2] = customColour;
        }
    }

    public void updateGrassColor() {
        this.grassColor = this.tryGettingColor(this.grassState, null, null);
        this.foliageColor = this.tryGettingColor(this.oakLeavesState, null, null);
        if (WorldMapClientConfigUtils.getDebug()) {
            WorldMap.LOGGER.info("Default grass colour: " + this.grassColor);
        }
    }

    public void updateDefaultResolvers(World world) {
        if (world == null) {
            return;
        }
        IBlockState grassState = Blocks.GRASS.getDefaultState();
        this.DEFAULT_GRASS_RESOLVER = XaeroWorldMapCore.detectColorResolver(grassState, world, new BlockPos(0, 0, 0), this.mapWriter.getBlockTintIndex(grassState), null, null, null);
        if (this.DEFAULT_GRASS_RESOLVER == null) {
            this.DEFAULT_GRASS_RESOLVER = this.getDefaultGrassResolver();
            this.detectionWorks = false;
        }
        IBlockState foliageState = Blocks.LEAVES.getDefaultState();
        this.DEFAULT_FOLIAGE_RESOLVER = XaeroWorldMapCore.detectColorResolver(foliageState, world, new BlockPos(0, 0, 0), this.mapWriter.getBlockTintIndex(foliageState), null, null, null);
        if (this.DEFAULT_FOLIAGE_RESOLVER == null) {
            this.DEFAULT_FOLIAGE_RESOLVER = this.getDefaultFoliageResolver();
            this.detectionWorks = false;
        }
        IBlockState waterState = Blocks.WATER.getDefaultState();
        this.DEFAULT_WATER_RESOLVER = XaeroWorldMapCore.detectColorResolver(waterState, world, new BlockPos(0, 0, 0), this.mapWriter.getBlockTintIndex(waterState), null, null, null);
        if (this.DEFAULT_WATER_RESOLVER == null) {
            this.DEFAULT_WATER_RESOLVER = this.getDefaultWaterResolver();
            this.detectionWorks = false;
        }
    }

    private int tryGettingColor(IBlockState state, World world, BlockPos pos) {
        try {
            return Minecraft.getMinecraft().getBlockColors().colorMultiplier(state, (IBlockAccess)world, pos, this.mapWriter.getBlockTintIndex(state));
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            return 0;
        }
    }

    public Object getColorResolver(IBlockState state, World world, BlockPos pos) {
        Object detection;
        Object object = detection = this.detectionWorks ? XaeroWorldMapCore.detectColorResolver(state, world, pos, this.mapWriter.getBlockTintIndex(state), this.DEFAULT_GRASS_RESOLVER, this.DEFAULT_FOLIAGE_RESOLVER, this.DEFAULT_WATER_RESOLVER) : null;
        if (detection != null) {
            return detection;
        }
        return this.defaultColorResolversCache.get(state);
    }

    private Object getDefaultGrassResolver() {
        return ReflectionUtils.getReflectFieldValue(null, (Field)this.defaultGrassResolverField);
    }

    private Object getDefaultFoliageResolver() {
        return ReflectionUtils.getReflectFieldValue(null, (Field)this.defaultFoliageResolverField);
    }

    private Object getDefaultWaterResolver() {
        return ReflectionUtils.getReflectFieldValue(null, (Field)this.defaultWaterResolverField);
    }
}

