/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.effects;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class WorldMapEffect
extends Potion {
    private ResourceLocation iconTexture;

    protected WorldMapEffect(EffectType type, int liquidColorIn, String idPrefix) {
        super(type == EffectType.HARMFUL, liquidColorIn);
        if (type == EffectType.BENEFICIAL) {
            this.setBeneficial();
        }
        ResourceLocation id = new ResourceLocation("xaeroworldmap", idPrefix + (type == EffectType.BENEFICIAL ? "_beneficial" : (type == EffectType.HARMFUL ? "_harmful" : "")));
        this.setRegistryName(id);
        this.setPotionName("effect." + id.getResourceDomain() + "." + id.getResourcePath());
        this.iconTexture = new ResourceLocation(id.getResourceDomain(), "textures/mob_effect/" + id.getResourcePath() + ".png");
    }

    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        super.renderHUDEffect(effect, gui, x, y, z, alpha);
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.iconTexture);
        Gui.drawModalRectWithCustomSizedTexture((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        super.renderInventoryEffect(effect, gui, x, y, z);
        this.renderHUDEffect(effect, gui, x + 3, y + 4, z, 1.0f);
    }

    public static enum EffectType {
        NEUTRAL,
        BENEFICIAL,
        HARMFUL;

    }
}

