/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.client.config.option.ui.ConfigOptionScreenEntry;
import xaero.lib.client.gui.CustomSettingEntry;
import xaero.lib.client.gui.GuiSettings;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.util.ConfigConstants;
import xaero.lib.common.gui.widget.TooltipInfo;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.file.export.PNGExportResult;
import xaero.map.gui.MapTileSelection;

public class ExportScreen
extends GuiSettings {
    private static final ITextComponent EXPORTING_MESSAGE = new TextComponentTranslation("gui.xaero_export_screen_exporting", new Object[0]);
    private final MapProcessor mapProcessor;
    private PNGExportResult result;
    private int stage;
    private final MapTileSelection selection;
    public boolean fullExport;

    public ExportScreen(GuiScreen backScreen, GuiScreen escScreen, MapProcessor mapProcessor, MapTileSelection selection) {
        super((ITextComponent)new TextComponentTranslation("gui.xaero_export_screen", new Object[0]), backScreen, escScreen);
        this.mapProcessor = mapProcessor;
        this.selection = selection;
        CustomSettingEntry fullExportEntry = new CustomSettingEntry(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        }, (ITextComponent)new TextComponentTranslation("gui.xaero_export_option_full", new Object[0]), new TooltipInfo("gui.xaero_box_export_option_full"), false, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ExportScreen.this.fullExport;
            }
        }, 0, 1, (IntFunction)new IntFunction<Boolean>(){

            @Override
            public Boolean apply(int i) {
                return i == 1;
            }
        }, (Function)new Function<Boolean, ITextComponent>(){

            @Override
            public ITextComponent apply(Boolean v) {
                return v != false ? ConfigConstants.ON : ConfigConstants.OFF;
            }
        }, (BiConsumer)new BiConsumer<Boolean, Boolean>(){

            @Override
            public void accept(Boolean o, Boolean n) {
                ExportScreen.this.fullExport = n;
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return true;
            }
        });
        this.entries = new ISettingEntry[]{fullExportEntry, this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.EXPORT_MULTIPLE_IMAGES), this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.NIGHT_EXPORT), this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.EXPORT_HIGHLIGHTS), this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.EXPORT_SCALE_DOWN_SQUARE)};
        this.canSearch = false;
        this.confirmButton = true;
        this.canSkipWorldRender = true;
    }

    public void initGui() {
        if (this.stage > 0) {
            return;
        }
        super.initGui();
    }

    protected void confirm() {
        this.stage = 1;
        this.setWorldAndResolution(this.mc, this.width, this.height);
    }

    public void drawScreen(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        super.drawScreen(par1, par2, par3);
        if (this.result != null) {
            this.drawCenteredString(this.mc.fontRenderer, this.result.getMessage().getFormattedText(), this.width / 2, this.height / 7 + 29 + 96, -1);
        }
        if (this.stage > 0) {
            this.drawCenteredString(this.mc.fontRenderer, EXPORTING_MESSAGE.getFormattedText(), this.width / 2, this.height / 6 + 68, -1);
            if (this.stage == 1) {
                this.stage = 2;
                return;
            }
        }
        if (this.stage != 2) {
            return;
        }
        if (this.mapProcessor.getMapSaveLoad().exportPNG(this, this.fullExport ? null : this.selection)) {
            this.stage = 3;
            this.result = null;
            for (GuiButton c : this.buttonList) {
                c.enabled = false;
            }
            return;
        }
        this.stage = 0;
        this.setWorldAndResolution(this.mc, this.width, this.height);
    }

    public <T> ConfigOptionScreenEntry<T> primaryOptionEntry(ConfigOption<T> option) {
        final ConfigChannel channel = WorldMap.INSTANCE.getConfigs();
        return new ConfigOptionScreenEntry(option, (Supplier)new Supplier<Config>(){

            @Override
            public Config get() {
                return channel.getPrimaryClientConfigManager().getConfig();
            }
        }, (Supplier)new Supplier<Config>(){

            @Override
            public Config get() {
                return null;
            }
        }, new Runnable(){

            @Override
            public void run() {
                channel.getPrimaryClientConfigManagerIO().save();
            }
        }, channel, true, false);
    }

    public void onExportDone(PNGExportResult result) {
        this.result = result;
        this.stage = 0;
    }

    public MapTileSelection getSelection() {
        return this.selection;
    }
}

