/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Keyboard;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapWorld;

public class GuiMapTpCommand
extends ScreenBase {
    protected String screenTitle;
    private MySmallButton confirmButton;
    private GuiTextField commandFormatTextField;
    private GuiTextField dimensionCommandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;
    private String dimensionCommandFormat;
    private MapWorld mapWorld;

    public GuiMapTpCommand(GuiScreen parent, GuiScreen escape) {
        super(parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_wm_teleport_command", new Object[0]));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultMapTeleport();
        this.commandFormat = mapWorld.getTeleportCommandFormat();
        this.dimensionCommandFormat = mapWorld.getDimensionTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void initGui() {
        super.initGui();
        this.screenTitle = I18n.format((String)"gui.xaero_wm_teleport_command", (Object[])new Object[0]);
        WorldMapSession session = WorldMapSession.getCurrentSession();
        final MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        final String defaultMapTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_FORMAT);
        final String defaultMapTeleportDimensionFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_DIMENSION_FORMAT);
        this.commandFormatTextField = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, this.height / 7 + 60, 200, 20);
        this.commandFormatTextField.setMaxStringLength(500);
        this.commandFormatTextField.setText(this.usingDefault ? defaultMapTeleportFormat : this.commandFormat);
        this.dimensionCommandFormatTextField = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, this.height / 7 + 90, 200, 20);
        this.dimensionCommandFormatTextField.setMaxStringLength(500);
        this.dimensionCommandFormatTextField.setText(this.usingDefault ? defaultMapTeleportDimensionFormat : this.dimensionCommandFormat);
        if (this.usingDefault) {
            this.commandFormatTextField.setEnabled(false);
            this.dimensionCommandFormatTextField.setEnabled(false);
            this.commandFormatTextField.setTextColor(-11184811);
            this.dimensionCommandFormatTextField.setTextColor(-11184811);
        } else {
            this.commandFormatTextField.setGuiResponder(new GuiPageButtonList.GuiResponder(){

                public void setEntryValue(int id, String text) {
                    GuiMapTpCommand.this.commandFormat = text;
                }

                public void setEntryValue(int id, float value) {
                    this.setEntryValue(id, value + "");
                }

                public void setEntryValue(int id, boolean value) {
                    this.setEntryValue(id, value + "");
                }
            });
            this.dimensionCommandFormatTextField.setGuiResponder(new GuiPageButtonList.GuiResponder(){

                public void setEntryValue(int id, String text) {
                    GuiMapTpCommand.this.dimensionCommandFormat = text;
                }

                public void setEntryValue(int id, float value) {
                    this.setEntryValue(id, value + "");
                }

                public void setEntryValue(int id, boolean value) {
                    this.setEntryValue(id, value + "");
                }
            });
        }
        this.textFields.add(this.commandFormatTextField);
        this.textFields.add(this.dimensionCommandFormatTextField);
        if (SupportMods.minimap()) {
            this.addButton((GuiButton)new MySmallButton(0, this.width / 2 - 75, this.height / 7 + 138, I18n.format((String)"gui.xaero_wm_teleport_command_waypoints", (Object[])new Object[0])){

                protected void onPress() {
                    SupportMods.xaeroMinimap.openWaypointWorldTeleportCommandScreen((GuiScreen)GuiMapTpCommand.this, GuiMapTpCommand.this.escape);
                }
            });
        }
        this.confirmButton = new MySmallButton(1, this.width / 2 - 155, this.height / 6 + 168, I18n.format((String)"gui.xaero_confirm", (Object[])new Object[0])){

            protected void onPress() {
                if (GuiMapTpCommand.this.canConfirm()) {
                    if (!GuiMapTpCommand.this.usingDefault && GuiMapTpCommand.this.commandFormat.equals(defaultMapTeleportFormat) && GuiMapTpCommand.this.dimensionCommandFormat.equals(defaultMapTeleportDimensionFormat)) {
                        GuiMapTpCommand.this.usingDefault = true;
                    }
                    mapWorld.setTeleportCommandFormat(GuiMapTpCommand.this.commandFormat);
                    mapWorld.setDimensionTeleportCommandFormat(GuiMapTpCommand.this.dimensionCommandFormat);
                    mapWorld.setUseDefaultMapTeleport(GuiMapTpCommand.this.usingDefault);
                    mapWorld.saveConfig();
                    GuiMapTpCommand.this.goBack();
                }
            }
        };
        this.addButton((GuiButton)this.confirmButton);
        this.addButton((GuiButton)new MySmallButton(2, this.width / 2 + 5, this.height / 6 + 168, I18n.format((String)"gui.xaero_cancel", (Object[])new Object[0])){

            protected void onPress() {
                GuiMapTpCommand.this.goBack();
            }
        });
        this.addButton((GuiButton)new MySmallButton(202, this.width / 2 - 75, this.height / 7 + 20, ConfigUtils.optionNameValue((ITextComponent)new TextComponentTranslation("gui.xaero_wm_use_default", new Object[0]), (ITextComponent)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault))){

            protected void onPress() {
                GuiMapTpCommand.this.usingDefault = !GuiMapTpCommand.this.usingDefault;
                GuiMapTpCommand.this.setWorldAndResolution(GuiMapTpCommand.this.mc, GuiMapTpCommand.this.width, GuiMapTpCommand.this.height);
            }
        });
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void drawScreen(int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(mouseX, mouseY, partial);
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        if (SupportMods.minimap()) {
            this.drawCenteredString(this.fontRenderer, I18n.format((String)"gui.xaero_wm_teleport_command_waypoints_hint", (Object[])new Object[0]), this.width / 2, this.height / 7 + 124, -5592406);
        }
        this.drawCenteredString(this.fontRenderer, "{x} {y} {z} {d}", this.width / 2, this.height / 7 + 46, -5592406);
        super.drawScreen(mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0 && this.dimensionCommandFormat != null && this.dimensionCommandFormat.length() > 0;
    }

    public void updateScreen() {
        super.updateScreen();
        this.confirmButton.enabled = this.canConfirm();
    }

    public void keyTyped(char par1, int par2) throws IOException {
        super.keyTyped(par1, par2);
        if ((par2 == 28 || par2 == 156) && this.canConfirm()) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }
}

