/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Keyboard;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.world.MapWorld;

public class GuiPlayerTpCommand
extends ScreenBase {
    protected String screenTitle;
    private MySmallButton confirmButton;
    private GuiTextField commandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;
    private MapWorld mapWorld;

    public GuiPlayerTpCommand(GuiScreen parent, GuiScreen escape) {
        super(parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_wm_player_teleport_command", new Object[0]));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultPlayerTeleport();
        this.commandFormat = mapWorld.getPlayerTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void initGui() {
        super.initGui();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        final String defaultPlayerTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_PLAYER_TELEPORT_FORMAT);
        this.screenTitle = I18n.format((String)"gui.xaero_wm_player_teleport_command", (Object[])new Object[0]);
        WorldMapSession session = WorldMapSession.getCurrentSession();
        this.mapWorld = session.getMapProcessor().getMapWorld();
        this.commandFormatTextField = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, this.height / 7 + 60, 200, 20);
        this.commandFormatTextField.setText(this.usingDefault ? defaultPlayerTeleportFormat : this.commandFormat);
        this.commandFormatTextField.setMaxStringLength(500);
        if (this.usingDefault) {
            this.commandFormatTextField.setTextColor(-11184811);
            this.commandFormatTextField.setEnabled(false);
        } else {
            this.commandFormatTextField.setGuiResponder(new GuiPageButtonList.GuiResponder(){

                public void setEntryValue(int id, String text) {
                    GuiPlayerTpCommand.this.commandFormat = text;
                }

                public void setEntryValue(int id, float value) {
                    this.setEntryValue(id, value + "");
                }

                public void setEntryValue(int id, boolean value) {
                    this.setEntryValue(id, value + "");
                }
            });
        }
        this.textFields.add(this.commandFormatTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, I18n.format((String)"gui.xaero_confirm", (Object[])new Object[0])){

            protected void onPress() {
                if (!GuiPlayerTpCommand.this.canConfirm()) {
                    return;
                }
                if (!GuiPlayerTpCommand.this.usingDefault && GuiPlayerTpCommand.this.commandFormat.equals(defaultPlayerTeleportFormat)) {
                    GuiPlayerTpCommand.this.usingDefault = true;
                }
                GuiPlayerTpCommand.this.mapWorld.setUseDefaultPlayerTeleport(GuiPlayerTpCommand.this.usingDefault);
                GuiPlayerTpCommand.this.mapWorld.setPlayerTeleportCommandFormat(GuiPlayerTpCommand.this.commandFormat);
                GuiPlayerTpCommand.this.mapWorld.saveConfig();
                GuiPlayerTpCommand.this.goBack();
            }
        };
        this.addButton((GuiButton)this.confirmButton);
        this.addButton((GuiButton)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, I18n.format((String)"gui.xaero_cancel", (Object[])new Object[0])){

            protected void onPress() {
                GuiPlayerTpCommand.this.goBack();
            }
        });
        this.addButton((GuiButton)new MySmallButton(202, this.width / 2 - 75, this.height / 7 + 20, ConfigUtils.optionNameValue((ITextComponent)new TextComponentTranslation("gui.xaero_wm_use_default", new Object[0]), (ITextComponent)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault))){

            protected void onPress() {
                GuiPlayerTpCommand.this.usingDefault = !GuiPlayerTpCommand.this.usingDefault;
                GuiPlayerTpCommand.this.setWorldAndResolution(GuiPlayerTpCommand.this.mc, GuiPlayerTpCommand.this.width, GuiPlayerTpCommand.this.height);
            }
        });
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void drawScreen(int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(mouseX, mouseY, partial);
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, "{x} {y} {z} {name}", this.width / 2, this.height / 7 + 46, -5592406);
        super.drawScreen(mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0;
    }

    public void updateScreen() {
        super.updateScreen();
        this.confirmButton.enabled = this.canConfirm();
    }

    public void keyTyped(char par1, int par2) throws IOException {
        super.keyTyped(par1, par2);
        if ((par2 == 28 || par2 == 156) && this.canConfirm()) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }
}

