/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.common.packet.XaeroPacket;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;

public class ClientboundRulesPacket
extends XaeroPacket {
    public boolean allowCaveModeOnServer;
    public boolean allowNetherCaveModeOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
    }

    public ClientboundRulesPacket() {
    }

    protected void read(PacketBuffer buf) {
        NBTTagCompound nbt;
        try {
            nbt = buf.readCompoundTag();
        }
        catch (IOException e) {
            return;
        }
        this.allowCaveModeOnServer = nbt.getBoolean("cm");
        this.allowNetherCaveModeOnServer = nbt.getBoolean("ncm");
    }

    protected void write(PacketBuffer buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setBoolean("cm", this.allowCaveModeOnServer);
        nbt.setBoolean("ncm", this.allowNetherCaveModeOnServer);
        buf.writeCompoundTag(nbt);
    }

    public static class ClientHandler
    implements Consumer<ClientboundRulesPacket> {
        @Override
        public void accept(ClientboundRulesPacket message) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

