/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import java.util.function.Function;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.misc.CachedFunction;

public class CaveStartCalculator {
    private final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
    private final CachedFunction<IBlockState, Boolean> transparentCache;
    private final MapWriter mapWriter;

    public CaveStartCalculator(final MapWriter mapWriter) {
        this.mapWriter = mapWriter;
        this.transparentCache = new CachedFunction<IBlockState, Boolean>(new Function<IBlockState, Boolean>(){

            @Override
            public Boolean apply(IBlockState state) {
                return mapWriter.shouldOverlay(state);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCaving(double playerX, double playerY, double playerZ, World world) {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        int autoCaveModeConfig = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.AUTO_CAVE_MODE);
        if (autoCaveModeConfig == 0) {
            return Integer.MAX_VALUE;
        }
        int y = Math.max((int)playerY + 1, 0);
        int defaultCaveStart = y + 3;
        int defaultResult = Integer.MAX_VALUE;
        if (y > 255 || y < 0) {
            return defaultResult;
        }
        int x = MathHelper.floor((double)playerX);
        int z = MathHelper.floor((double)playerZ);
        int roofRadius = autoCaveModeConfig < 0 ? 1 : autoCaveModeConfig - 1;
        int roofDiameter = 1 + roofRadius * 2;
        int startX = x - roofRadius;
        int startZ = z - roofRadius;
        boolean ignoringHeightmaps = this.mapWriter.getMapProcessor().getMapWorld().isIgnoreHeightmaps();
        int bottom = y;
        int top = -1;
        Chunk prevBChunk = null;
        int potentialResult = defaultCaveStart;
        for (int o = 0; o < roofDiameter; ++o) {
            block1: for (int p = 0; p < roofDiameter; ++p) {
                int currentX = startX + o;
                int currentZ = startZ + p;
                this.mutableBlockPos.setPos(currentX, y, currentZ);
                Chunk bchunk = world.getChunkFromChunkCoords(currentX >> 4, currentZ >> 4);
                if (bchunk == null) {
                    return defaultResult;
                }
                int skyLight = bchunk.getLightFor(EnumSkyBlock.SKY, (BlockPos)this.mutableBlockPos);
                if (!ignoringHeightmaps) {
                    if (skyLight >= 15) return defaultResult;
                    int insideX = currentX & 0xF;
                    int insideZ = currentZ & 0xF;
                    top = bchunk.getHeightValue(insideX, insideZ);
                } else if (bchunk != prevBChunk) {
                    ExtendedBlockStorage[] sections = bchunk.getBlockStorageArray();
                    if (sections.length == 0) {
                        return defaultResult;
                    }
                    int playerSection = y >> 4;
                    boolean foundSomething = false;
                    for (int i = playerSection; i < sections.length; ++i) {
                        ExtendedBlockStorage searchedSection = sections[i];
                        if (searchedSection == Chunk.NULL_BLOCK_STORAGE) continue;
                        if (!foundSomething) {
                            bottom = Math.max(bottom, i << 4);
                            foundSomething = true;
                        }
                        top = (i << 4) + 15;
                    }
                    if (!foundSomething) {
                        return defaultResult;
                    }
                    prevBChunk = bchunk;
                }
                if (top < 0) {
                    return defaultResult;
                }
                if (top > 255) {
                    top = 255;
                }
                for (int i = bottom; i <= top; ++i) {
                    this.mutableBlockPos.setY(i);
                    IBlockState state = world.getBlockState((BlockPos)this.mutableBlockPos);
                    if (state.getBlock() instanceof BlockAir || state.getMaterial().getMobilityFlag() == EnumPushReaction.DESTROY || state.getMaterial() == Material.LEAVES || state.getBlock() instanceof BlockLiquid || this.transparentCache.apply(state).booleanValue() || state.getBlock() == Blocks.BARRIER) continue;
                    if (o != p || o != roofRadius) continue block1;
                    potentialResult = Math.min(i, defaultCaveStart);
                    continue block1;
                }
                return defaultResult;
            }
        }
        return potentialResult;
    }
}

