/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import xaero.map.mods.gui.WaypointMenuElement;

public class WaypointMenuScroll
extends WaypointMenuElement {
    private String name;
    private String icon;
    private int direction;
    private long lastScroll;

    public WaypointMenuScroll(String name, String icon, int direction) {
        this.name = name;
        this.icon = icon;
        this.direction = direction;
    }

    @Override
    public int getLeftSideLength(Minecraft mc) {
        return 9 + mc.fontRenderer.getStringWidth(I18n.format((String)this.name, (Object[])new Object[0]));
    }

    @Override
    public void renderInMenu(GuiScreen gui, int x, int y, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        GlStateManager.pushMatrix();
        if (enabled && hovered) {
            GlStateManager.translate((float)(pressed ? 1.0f : 2.0f), (float)0.0f, (float)0.0f);
        }
        GlStateManager.translate((float)x, (float)y, (float)0.0f);
        if (enabled) {
            GlStateManager.scale((double)scale, (double)scale, (double)1.0);
        }
        GlStateManager.translate((float)-4.0f, (float)-4.0f, (float)0.0f);
        GlStateManager.enableBlend();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = enabled ? -1 : -11184811;
        mc.fontRenderer.drawStringWithShadow(this.icon, (float)(5 - mc.fontRenderer.getStringWidth(this.icon) / 2), 1.0f, color);
        String name = I18n.format((String)this.name, (Object[])new Object[0]);
        int len = mc.fontRenderer.getStringWidth(name);
        mc.fontRenderer.drawStringWithShadow(name, (float)(-3 - len), 0.0f, color);
        GlStateManager.enableBlend();
        GlStateManager.popMatrix();
    }

    public int getDirection() {
        return this.direction;
    }

    public int scroll() {
        long currentTime = System.currentTimeMillis();
        if (this.lastScroll == 0L || currentTime - this.lastScroll > 100L) {
            this.lastScroll = currentTime;
            return this.direction;
        }
        return 0;
    }

    public void onMouseRelease() {
        this.lastScroll = 0L;
    }
}

