/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.animation.SlowingAnimation;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.element.MapElementRenderer;
import xaero.map.element.render.ElementRenderInfo;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.PlayerTrackerMapElementCollector;
import xaero.map.radar.tracker.PlayerTrackerMapElementReader;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderContext;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderProvider;
import xaero.map.radar.tracker.TrackedPlayerIconManager;
import xaero.map.world.MapDimension;

public final class PlayerTrackerMapElementRenderer
extends MapElementRenderer<PlayerTrackerMapElement<?>, PlayerTrackerMapElementRenderContext, PlayerTrackerMapElementRenderer> {
    private final PlayerTrackerMapElementCollector elementCollector;
    private TrackedPlayerIconManager trackedPlayerIconManager;
    private ElementRenderInfo compatibleRenderInfo;

    private PlayerTrackerMapElementRenderer(PlayerTrackerMapElementCollector elementCollector, PlayerTrackerMapElementRenderContext context, PlayerTrackerMapElementRenderProvider<PlayerTrackerMapElementRenderContext> provider, PlayerTrackerMapElementReader reader) {
        super(context, provider, reader);
        this.elementCollector = elementCollector;
    }

    public TrackedPlayerIconManager getTrackedPlayerIconManager() {
        return this.trackedPlayerIconManager;
    }

    @Override
    public void preRender(ElementRenderInfo renderInfo, boolean shadow) {
        Minecraft mc = Minecraft.getMinecraft();
        WorldMapSession mapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = mapSession.getMapProcessor();
        ((PlayerTrackerMapElementRenderContext)this.context).mapDimId = mapProcessor.getMapWorld().getCurrentDimensionId();
        ((PlayerTrackerMapElementRenderContext)this.context).mapDimDiv = mapProcessor.getMapWorld().getCurrentDimension().calculateDimDiv(mc.world.provider);
    }

    @Override
    public void postRender(ElementRenderInfo renderInfo, boolean shadow) {
        if (!shadow) {
            this.elementCollector.resetRenderedOnRadarFlags();
        }
    }

    @Override
    public void renderElementShadow(PlayerTrackerMapElement<?> element, boolean hovered, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo) {
    }

    @Override
    public boolean renderElement(PlayerTrackerMapElement<?> e, boolean hovered, double optionalDepth, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo) {
        NetworkPlayerInfo info = Minecraft.getMinecraft().getConnection().getPlayerInfo(e.getPlayerId());
        if (info != null) {
            boolean firstTime;
            Minecraft mc = Minecraft.getMinecraft();
            FontRenderer fontRenderer = mc.fontRenderer;
            EntityPlayer clientPlayer = mc.world.getPlayerEntityByUUID(e.getPlayerId());
            GlStateManager.pushMatrix();
            double fadeDest = hovered ? 1.0 : 0.0;
            boolean bl = firstTime = e.getFadeAnim() == null;
            if (firstTime || e.getFadeAnim().getDestination() != fadeDest) {
                e.setFadeAnim(new SlowingAnimation(e.getFadeAnim() == null ? 0.0 : e.getFadeAnim().getCurrent(), fadeDest, 0.8, 0.001));
            }
            float alpha = (float)e.getFadeAnim().getCurrent();
            if (!e.wasRenderedOnRadar() || alpha > 0.0f) {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (alpha > 0.0f) {
                    GlStateManager.pushMatrix();
                    GlStateManager.scale((float)2.0f, (float)2.0f, (float)1.0f);
                    String name = info.getGameProfile().getName();
                    int nameWidth = fontRenderer.getStringWidth(name);
                    Gui.drawRect((int)(-8 - nameWidth - 2), (int)-6, (int)-7, (int)6, (int)((int)(alpha * 119.0f) << 24));
                    GlStateManager.enableBlend();
                    int textAlphaComponent = (int)(alpha * 255.0f);
                    if (textAlphaComponent > 3) {
                        int tc = 0xFFFFFF | textAlphaComponent << 24;
                        fontRenderer.drawStringWithShadow(name, (float)(-8 - nameWidth), -4.0f, tc);
                    }
                    GlStateManager.popMatrix();
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlStateManager.translate((double)partialX, (double)partialY, (double)0.0);
                GlStateManager.scale((float)((2.0f + alpha) / 3.0f), (float)((2.0f + alpha) / 3.0f), (float)1.0f);
                XaeroIcon icon = this.getTrackedPlayerIconManager().getIcon(clientPlayer, info, e, renderInfo.scaledResolution);
                XaeroIconAtlas atlas = icon.getTextureAtlas();
                GlStateManager.bindTexture((int)atlas.getTextureId());
                Gui.drawScaledCustomSizeModalRect((int)-15, (int)-15, (float)(icon.getOffsetX() + 1), (float)(icon.getOffsetY() + 31), (int)30, (int)-30, (int)30, (int)30, (float)atlas.getWidth(), (float)atlas.getWidth());
            }
            GlStateManager.popMatrix();
        }
        return false;
    }

    @Override
    @Deprecated
    public void beforeRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        this.preRender(null, pre);
    }

    @Override
    @Deprecated
    public void afterRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        this.postRender(null, pre);
        this.compatibleRenderInfo = null;
    }

    @Override
    @Deprecated
    public void renderElementPre(int location, PlayerTrackerMapElement<?> element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        this.renderElementShadow(element, hovered, optionalScale, partialX, partialY, (ElementRenderInfo)null);
    }

    @Override
    @Deprecated
    public boolean renderElement(int location, PlayerTrackerMapElement<?> element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        if (this.compatibleRenderInfo == null) {
            MapProcessor mapProcessor = WorldMapSession.getCurrentSession().getMapProcessor();
            MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
            double mapDimScale = mapDimension.calculateDimScale();
            this.compatibleRenderInfo = new ElementRenderInfo(ElementRenderLocation.fromIndex(location), mc.getRenderViewEntity(), (EntityPlayer)mc.player, new Vec3d(cameraX, -1.0, cameraZ), mouseX, mouseZ, scale, cave, partialTicks, brightness, screenSizeBasedScale, null, scaledRes, mapDimScale, mapDimension.getDimId());
        }
        return this.renderElement(element, hovered, optionalDepth, optionalScale, partialX, partialY, this.compatibleRenderInfo);
    }

    @Override
    public boolean shouldRender(int location, boolean shadow) {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_TRACKED_PLAYERS);
    }

    @Override
    public int getOrder() {
        return 200;
    }

    public PlayerTrackerMapElementCollector getCollector() {
        return this.elementCollector;
    }

    public void update(Minecraft mc) {
        if (this.trackedPlayerIconManager == null) {
            this.trackedPlayerIconManager = TrackedPlayerIconManager.Builder.begin().build();
        }
        this.elementCollector.update(mc);
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMapElementRenderer build() {
            PlayerTrackerMapElementCollector collector = new PlayerTrackerMapElementCollector(WorldMap.playerTrackerSystemManager, new Runnable(){

                @Override
                public void run() {
                    WorldMap.trackedPlayerMenuRenderer.updateFilteredList();
                }
            });
            return new PlayerTrackerMapElementRenderer(collector, new PlayerTrackerMapElementRenderContext(), new PlayerTrackerMapElementRenderProvider(collector), new PlayerTrackerMapElementReader());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

