/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.MapUpdateFastConfig;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;
import xaero.map.world.MapDimension;

public class MapBlock
extends MapPixel {
    protected boolean slopeUnknown = true;
    private byte verticalSlope;
    private byte diagonalSlope;
    private byte signed_height;
    private byte signed_topHeight;
    private ArrayList<Overlay> overlays;
    private int biome = -1;

    public boolean isGrass() {
        return (this.state & 0xFFFF0000) == 0 && (this.state & 0xFFF) == 2;
    }

    public int getParametres() {
        int parametres = 0;
        int colourTypeToWrite = this.colourType < 0 ? 0 : this.colourType & 3;
        parametres |= !this.isGrass() ? 1 : 0;
        parametres |= this.getNumberOfOverlays() != 0 ? 2 : 0;
        parametres |= colourTypeToWrite << 2;
        parametres |= this.light << 8;
        parametres |= this.getHeight() << 12;
        parametres |= this.biome != -1 ? 0x100000 : 0;
        return parametres |= this.signed_height != this.signed_topHeight ? 0x1000000 : 0;
    }

    public void getPixelColour(int[] result_dest, MapWriter mapWriter, World world, MapDimension dim, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, int caveStart, int caveDepth, BlockPos.MutableBlockPos mutableGlobalPos, float shadowR, float shadowG, float shadowB, BiomeColorCalculator biomeColorCalculator, MapProcessor mapProcessor, OverlayManager overlayManager, int effectiveHeight, int effectiveTopHeight, BlockStateShortShapeCache blockStateShortShapeCache, MapUpdateFastConfig config) {
        super.getPixelColours(result_dest, mapWriter, world, dim, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, this, effectiveHeight, effectiveTopHeight, caveStart, caveDepth, this.overlays, mutableGlobalPos, shadowR, shadowG, shadowB, biomeColorCalculator, mapProcessor, overlayManager, blockStateShortShapeCache, config);
    }

    public String toString() {
        return "ID: " + Block.BLOCK_STATE_IDS.get((Object)Block.getStateById((int)this.getState())) + ", S: " + this.getState() + ", VS: " + this.verticalSlope + ", DS: " + this.diagonalSlope + ", SU: " + this.slopeUnknown + ", H: " + this.getHeight() + ", CT: " + this.colourType + ", B: " + this.biome + ", CC: " + this.customColour + ", L: " + this.light + ", G: " + this.glowing + ", O: " + this.getNumberOfOverlays();
    }

    public boolean equalsSlopesExcluded(MapBlock p) {
        boolean equal;
        boolean bl = equal = p != null && this.state == p.state && this.colourType == p.colourType && this.light == p.light && this.signed_height == p.signed_height && this.signed_topHeight == p.signed_topHeight && this.getNumberOfOverlays() == p.getNumberOfOverlays() && this.biome == p.biome && (this.colourType != 3 || this.customColour == p.customColour);
        if (equal && this.getNumberOfOverlays() != 0) {
            for (int i = 0; i < this.overlays.size(); ++i) {
                if (this.overlays.get(i).equals(p.overlays.get(i))) continue;
                return false;
            }
        }
        return equal;
    }

    public boolean equals(MapBlock p, boolean equalsSlopesExcluded) {
        return p != null && this.verticalSlope == p.verticalSlope && this.diagonalSlope == p.diagonalSlope && this.slopeUnknown == p.slopeUnknown && equalsSlopesExcluded;
    }

    public void fixHeightType(int x, int z, MapTile mapTile, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, int height, boolean useSourceData, BlockStateShortShapeCache blockStateShortShapeCache, MapUpdateFastConfig updateConfig) {
        int prevHeight = -1;
        int prevHeightDiagonal = -1;
        if (useSourceData && z > 0) {
            prevHeight = mapTile.getBlock(x, z - 1).getEffectiveHeight(blockStateShortShapeCache, updateConfig);
            if (x > 0) {
                prevHeightDiagonal = mapTile.getBlock(x - 1, z - 1).getEffectiveHeight(blockStateShortShapeCache, updateConfig);
            }
        }
        if (prevHeight == -1 || prevHeightDiagonal == -1) {
            boolean horisontalEdge;
            int inTileChunkX = ((mapTile.getChunkX() & 3) << 4) + x;
            int inTileChunkZ = ((mapTile.getChunkZ() & 3) << 4) + z;
            int inTileChunkXPrev = inTileChunkX - 1;
            int inTileChunkZPrev = inTileChunkZ - 1;
            MapTileChunk verticalSlopeSrc = tileChunk;
            MapTileChunk diagonalSlopeSrc = tileChunk;
            boolean verticalEdge = inTileChunkZPrev < 0;
            boolean bl = horisontalEdge = inTileChunkXPrev < 0;
            if (verticalEdge) {
                verticalSlopeSrc = diagonalSlopeSrc = prevChunk;
                inTileChunkZPrev = 63;
            }
            if (horisontalEdge) {
                inTileChunkXPrev = 63;
                MapTileChunk mapTileChunk = diagonalSlopeSrc = verticalEdge ? prevChunkDiagonal : prevChunkHorisontal;
            }
            if (prevHeight == -1 && verticalSlopeSrc != null && verticalSlopeSrc.getLoadState() >= 2) {
                prevHeight = verticalSlopeSrc.getLeafTexture().getHeight(inTileChunkX, inTileChunkZPrev);
            }
            if (prevHeightDiagonal == -1 && diagonalSlopeSrc != null && diagonalSlopeSrc.getLoadState() >= 2) {
                prevHeightDiagonal = diagonalSlopeSrc.getLeafTexture().getHeight(inTileChunkXPrev, inTileChunkZPrev);
            }
            if (prevHeight == -1 || prevHeightDiagonal == -1) {
                int reZ;
                if (useSourceData) {
                    return;
                }
                int reX = x < 15 ? x + 1 : x;
                int n = reZ = z < 15 ? z + 1 : z;
                if (reX == x && reZ == z) {
                    this.verticalSlope = 0;
                    this.diagonalSlope = 0;
                    this.slopeUnknown = false;
                    return;
                }
                int inTileChunkReX = ((mapTile.getChunkX() & 3) << 4) + reX;
                int inTileChunkReZ = ((mapTile.getChunkZ() & 3) << 4) + reZ;
                int reHeight = tileChunk.getLeafTexture().getHeight(inTileChunkReX, inTileChunkReZ);
                if (reHeight != -1) {
                    this.fixHeightType(reX, reZ, mapTile, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, reHeight, useSourceData, blockStateShortShapeCache, updateConfig);
                }
                return;
            }
        }
        this.verticalSlope = (byte)Math.max(-128, Math.min(127, height - prevHeight));
        this.diagonalSlope = (byte)Math.max(-128, Math.min(127, height - prevHeightDiagonal));
        this.slopeUnknown = false;
    }

    public void prepareForWriting() {
        if (this.overlays != null) {
            this.overlays.clear();
        }
        this.customColour = 0;
        this.colourType = 0;
        this.biome = -1;
        this.state = 0;
        this.slopeUnknown = true;
        this.light = 0;
        this.glowing = false;
        this.signed_height = 0;
        this.signed_topHeight = 0;
    }

    public void write(int state, int height, int topHeight, int[] biomeStuff, byte light, boolean glowing, boolean cave) {
        this.state = state;
        this.setHeight(height);
        this.setTopHeight(topHeight);
        this.setColourType((byte)biomeStuff[0]);
        if (biomeStuff[1] != -1) {
            this.biome = biomeStuff[1];
        }
        this.setCustomColour(biomeStuff[2]);
        this.light = light;
        this.glowing = glowing;
        if (this.overlays != null && this.overlays.isEmpty()) {
            this.overlays = null;
        }
    }

    public void addOverlay(Overlay o) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        this.overlays.add(o);
    }

    public int getHeight() {
        return this.signed_height & 0xFF;
    }

    public byte getSignedHeight() {
        return this.signed_height;
    }

    public void setHeight(int h) {
        this.signed_height = (byte)h;
    }

    public int getTopHeight() {
        return this.signed_topHeight & 0xFF;
    }

    public byte getSignedTopHeight() {
        return this.signed_topHeight;
    }

    public void setTopHeight(int h) {
        this.signed_topHeight = (byte)h;
    }

    public int getEffectiveHeight(BlockStateShortShapeCache blockStateShortShapeCache, MapUpdateFastConfig updateConfig) {
        return this.getEffectiveHeight(updateConfig.adjustHeightForShortBlocks && blockStateShortShapeCache.isShort(this.state));
    }

    public int getEffectiveHeight(boolean subtractOne) {
        int height = this.getHeight();
        if (subtractOne) {
            --height;
        }
        return height;
    }

    public int getEffectiveTopHeight(boolean subtractOne) {
        int topHeight = this.getTopHeight();
        if (subtractOne && topHeight == this.getHeight()) {
            --topHeight;
        }
        return topHeight;
    }

    public int getBiome() {
        return this.biome;
    }

    public void setBiome(int biome) {
        this.biome = biome;
    }

    public ArrayList<Overlay> getOverlays() {
        return this.overlays;
    }

    public byte getVerticalSlope() {
        return this.verticalSlope;
    }

    public void setVerticalSlope(byte slope) {
        this.verticalSlope = slope;
    }

    public byte getDiagonalSlope() {
        return this.diagonalSlope;
    }

    public void setDiagonalSlope(byte slope) {
        this.diagonalSlope = slope;
    }

    public void setSlopeUnknown(boolean slopeUnknown) {
        this.slopeUnknown = slopeUnknown;
    }

    public int getNumberOfOverlays() {
        return this.overlays == null ? 0 : this.overlays.size();
    }
}

