/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.server.radar.tracker;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class SyncedTrackedPlayer {
    private final UUID id;
    private double x;
    private double y;
    private double z;
    private int dimension;

    public SyncedTrackedPlayer(UUID id, double x, double y, double z, int dimension) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public SyncedTrackedPlayer setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public SyncedTrackedPlayer setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean matchesEnough(EntityPlayer player, double maxAxisDistance) {
        return Math.abs(player.posX - this.x) <= maxAxisDistance && Math.abs(player.posY - this.y) <= maxAxisDistance && Math.abs(player.posZ - this.z) <= maxAxisDistance && player.world.provider.getDimension() == this.dimension;
    }

    public void update(EntityPlayer player) {
        this.setPos(player.posX, player.posY, player.posZ).setDimension(player.world.provider.getDimension());
    }

    public void copyFrom(SyncedTrackedPlayer trackedPlayer) {
        this.setPos(trackedPlayer.getX(), trackedPlayer.getY(), trackedPlayer.getZ()).setDimension(trackedPlayer.getDimension());
    }
}

