/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.world;

import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapConnectionNode {
    private final int dimId;
    private final String mw;
    private String cachedString;

    public MapConnectionNode(int dimId, String mw) {
        this.dimId = dimId;
        this.mw = mw;
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.dimId + "/" + this.mw;
        }
        return this.cachedString;
    }

    public String getNamedString(MapWorld mapWorld) {
        MapDimension dim = mapWorld.getDimension(this.dimId);
        return dim.getDropdownLabel() + "/" + dim.getMultiworldName(this.mw);
    }

    public static MapConnectionNode fromString(String s) {
        int dimId;
        int dividerIndex = s.lastIndexOf(47);
        if (dividerIndex == -1) {
            return null;
        }
        String dimString = s.substring(0, dividerIndex);
        try {
            dimId = dimString.equals("minecraft$overworld") ? 0 : (dimString.equals("minecraft$the_nether") ? -1 : (dimString.equals("minecraft$the_end") ? 1 : Integer.parseInt(dimString)));
        }
        catch (Throwable t) {
            return null;
        }
        String mwString = s.substring(dividerIndex + 1);
        return new MapConnectionNode(dimId, mwString);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || !(another instanceof MapConnectionNode)) {
            return false;
        }
        MapConnectionNode anotherNode = (MapConnectionNode)another;
        return this.dimId == anotherNode.dimId && this.mw.equals(anotherNode.mw);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int getDimId() {
        return this.dimId;
    }

    public String getMw() {
        return this.mw;
    }
}

