/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import java.lang.reflect.Method;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.map.MapProcessor;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.region.MapTile;

public class BiomeColorCalculator {
    private Method colorResolverGetColorMethod;
    private int startO;
    private int endO;
    private int startP;
    private int endP;

    public BiomeColorCalculator() {
        try {
            Class colorResolverInterface = ReflectionUtils.getClassForName((String)"net.minecraft.world.biome.BiomeColorHelper$ColorResolver", (String)"net.minecraft.world.biome.BiomeColorHelper$ColorResolver");
            this.colorResolverGetColorMethod = ReflectionUtils.getMethodReflection((Class)colorResolverInterface, (String)"getColorAtPos", (String)"", (String)"", (String)"func_180283_a", Integer.TYPE, (Class[])new Class[]{Biome.class, BlockPos.class});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void prepare(boolean biomeBlending) {
        this.endP = 0;
        this.startP = 0;
        this.endO = 0;
        this.startO = 0;
        if (biomeBlending) {
            this.startO = -1;
            this.endO = 1;
            this.startP = -1;
            this.endP = 1;
        }
    }

    public int getBiomeColor(IBlockState state, boolean overlay, BlockPos.MutableBlockPos pos, MapTile tile, int caveLayer, World world, MapProcessor mapProcessor, BlockStateColorTypeCache blockStateColorTypeCache) {
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.getX();
        int initZ = pos.getZ();
        Object stateColorResolver = blockStateColorTypeCache.getColorResolver(state, world, (BlockPos)pos);
        if (stateColorResolver == null) {
            return -1;
        }
        for (int o = this.startO; o <= this.endO; ++o) {
            for (int p = this.startP; p <= this.endP; ++p) {
                if (o != 0 && p != 0) continue;
                pos.setPos(initX + o, pos.getY(), initZ + p);
                Integer b = this.getBiomeAtPos((BlockPos)pos, tile, caveLayer, mapProcessor);
                if (b == null) continue;
                if (b == -1 && overlay) {
                    b = Biome.getIdForBiome((Biome)Biomes.RIVER);
                }
                if (b == -1) continue;
                int l = 0;
                Biome gen = Biome.getBiome((int)b);
                if (gen == null) {
                    gen = world.provider.getBiomeProvider().getBiome((BlockPos)pos, Biomes.PLAINS);
                    b = Biome.getIdForBiome((Biome)gen);
                }
                if (gen == null) continue;
                l = this.resolve(stateColorResolver, gen, (BlockPos)pos);
                i += l & 0xFF0000;
                j += l & 0xFF00;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.setPos(initX, pos.getY(), initZ);
        if (total == 0) {
            Biome defaultBiome = Biomes.RIVER;
            if (defaultBiome == null) {
                return -1;
            }
            return this.resolve(stateColorResolver, defaultBiome, (BlockPos)pos);
        }
        return i / total & 0xFF0000 | j / total & 0xFF00 | k / total;
    }

    public Integer getBiomeAtPos(BlockPos pos, MapTile centerTile, int caveLayer, MapProcessor mapProcessor) {
        MapTile tile;
        int tileX = pos.getX() >> 4;
        int tileZ = pos.getZ() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : mapProcessor.getMapTile(caveLayer, tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.getX() & 0xF, pos.getZ() & 0xF).getBiome();
        }
        return null;
    }

    private int resolve(Object colorResolver, Biome biome, BlockPos pos) {
        return (Integer)ReflectionUtils.getReflectMethodValue((Object)colorResolver, (Method)this.colorResolverGetColorMethod, (Object[])new Object[]{biome, pos});
    }
}

