/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementMenuHitbox;
import xaero.map.element.MapElementMenuScroll;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MenuHitboxReader;
import xaero.map.element.MenuScrollReader;
import xaero.map.element.render.ElementReader;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;

public abstract class MapElementMenuRenderer<E, C> {
    private static final int MENU_RIGHT_PADDING = 27;
    public static final int MAX_MENU_SIZE = 10;
    public static final int MIN_MENU_SIZE = 2;
    protected final MapElementMenuScroll scrollUp = new MapElementMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    protected final MapElementMenuScroll scrollDown = new MapElementMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    protected final MapElementMenuHitbox extraHitbox;
    protected final MenuScrollReader scrollReader = new MenuScrollReader();
    protected final MenuHitboxReader hitboxReader;
    protected final C context;
    protected final MapElementRenderProvider<E, C> provider;
    protected ArrayList<E> filteredElements;
    private GuiTextField filterField;
    public int menuOffset = 0;
    protected Pattern searchPattern = null;
    protected Pattern searchStartPattern = null;
    protected final Minecraft mc;

    protected MapElementMenuRenderer(C context, MapElementRenderProvider<E, C> provider) {
        this.extraHitbox = new MapElementMenuHitbox(-150, 0, 177, 0);
        this.hitboxReader = new MenuHitboxReader();
        this.mc = Minecraft.getMinecraft();
        this.context = context;
        this.provider = provider;
    }

    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height) {
        String searchText = this.filterField == null ? "" : this.filterField.getText();
        this.filterField = new GuiTextField(0, mc.fontRenderer, screen.width - 172, this.menuStartPos(height) + 3 + this.menuSearchPadding(), 150, 20);
        this.filterField.setText(searchText);
    }

    public HoveredMapElementHolder<?, ?> renderMenu(GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc) {
        int menuStartPos;
        if (this.filteredElements == null) {
            this.updateFilteredList();
        }
        ArrayList<E> elements = this.filteredElements;
        int menuElementCount = MapElementMenuRenderer.getMenuElementCount(this.menuStartPos(height));
        if (this.menuOffset + menuElementCount > elements.size()) {
            this.menuOffset = elements.size() - menuElementCount;
        }
        if (this.menuOffset < 0) {
            this.menuOffset = 0;
        }
        int offset = this.menuOffset;
        Object viewed = null;
        int yPos = menuStartPos = this.menuStartPos(height);
        int elementCount = MapElementMenuRenderer.getMenuElementCount(yPos);
        this.beforeMenuRender();
        viewed = this.renderMenuElement(this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (GuiScreen)gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < elements.size(); ++i) {
            viewed = this.renderMenuElement(elements.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (GuiScreen)gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderMenuElement(this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (GuiScreen)gui, offset < elements.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            Minecraft.getMinecraft().getSoundHandler().playSound((ISound)PositionedSoundRecord.getMasterRecord((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof MapElementMenuScroll) {
            int direction = ((MapElementMenuScroll)viewed).scroll();
            this.menuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderMenuElement(this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, (GuiScreen)gui, true, mc);
        }
        this.afterMenuRender();
        return oldHovered != null && oldHovered.equals(viewed) ? oldHovered : (viewed == null ? null : MapElementRenderHandler.createResult(viewed, this.getAnyRenderer(viewed)));
    }

    protected abstract void beforeMenuRender();

    protected abstract void afterMenuRender();

    public void postMapRender(GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        String searchText = this.filterField.getText();
        boolean searchFieldPlaceHolder = searchText.isEmpty() && !this.filterField.isFocused();
        boolean invalidRegex = false;
        if (searchFieldPlaceHolder) {
            GuiUtils.setFieldText((GuiTextField)this.filterField, (String)I18n.format((String)this.getFilterPlaceholder(), (Object[])new Object[0]), (int)-11184811);
        } else if (!searchText.isEmpty() && this.searchPattern == null) {
            invalidRegex = true;
        }
        this.filterField.drawTextBox();
        if (searchFieldPlaceHolder) {
            GuiUtils.setFieldText((GuiTextField)this.filterField, (String)"");
        } else if (invalidRegex) {
            String errorMessage = I18n.format((String)"gui.xaero_wm_search_invalid_regex", (Object[])new Object[0]);
            gui.drawString(this.mc.fontRenderer, errorMessage, width - 176 - this.mc.fontRenderer.getStringWidth(errorMessage), this.filterField.y + 6, -43691);
        }
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private <O> Object renderMenuElement(O element, int width, int yPos, int mouseX, int mouseY, Object viewed, boolean leftMousePressed, GuiScreen gui, boolean enabled, Minecraft mc) {
        boolean hovered;
        MenuScrollReader reader = element == this.scrollDown || element == this.scrollUp ? this.scrollReader : (element == this.extraHitbox ? this.hitboxReader : this.getAnyRenderer(element).getReader());
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && reader.isMouseOverMenuElement(element, xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        if (element != this.extraHitbox) {
            this.renderMenuElement(reader, element, gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        }
        return viewed;
    }

    public <O> void renderMenuElement(ElementReader<O, ?, ?> reader, O element, GuiScreen gui, int x, int y, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        GlStateManager.pushMatrix();
        if (hovered) {
            GlStateManager.translate((float)(pressed ? 1.0f : 2.0f), (float)0.0f, (float)0.0f);
        }
        GlStateManager.translate((float)x, (float)y, (float)0.0f);
        GlStateManager.scale((float)((float)scale), (float)((float)scale), (float)1.0f);
        GlStateManager.translate((float)-4.0f, (float)-4.0f, (float)0.0f);
        String name = reader.getMenuName(element);
        int len = mc.fontRenderer.getStringWidth(name);
        int textX = -3 - len;
        Gui.drawRect((int)(textX - 2 - reader.getMenuTextFillLeftPadding(element)), (int)-2, (int)(textX + len + 2), (int)11, (int)0x77000000);
        mc.fontRenderer.drawStringWithShadow(name, (float)textX, 0.0f, enabled ? -1 : -11184811);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        GlStateManager.translate((float)4.0f, (float)4.0f, (float)0.0f);
        if (element == this.scrollUp || element == this.scrollDown) {
            this.renderScroll((MapElementMenuScroll)element, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed);
        } else {
            O elementCast = element;
            this.renderInMenu(elementCast, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed, textX);
        }
        GlStateManager.popMatrix();
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void renderScroll(MapElementMenuScroll scroll, GuiScreen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        if (enabled && hovered) {
            GlStateManager.translate((float)(pressed ? 1.0f : 2.0f), (float)0.0f, (float)0.0f);
        }
        GlStateManager.translate((float)-4.0f, (float)-4.0f, (float)0.0f);
        GlStateManager.enableBlend();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = enabled ? -1 : -11184811;
        mc.fontRenderer.drawStringWithShadow(scroll.getIcon(), (float)(5 - mc.fontRenderer.getStringWidth(scroll.getIcon()) / 2), 1.0f, color);
        GlStateManager.enableBlend();
    }

    private void updateSearch() {
        String search = this.filterField.getText();
        try {
            this.searchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.searchStartPattern = search.charAt(0) == '^' ? this.searchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.searchStartPattern = null;
                this.searchPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            this.searchStartPattern = null;
            this.searchPattern = null;
        }
        this.updateFilteredList();
    }

    public boolean charTyped() {
        if (this.filterField.isFocused()) {
            this.updateSearch();
            return true;
        }
        return false;
    }

    public boolean keyPressed(GuiMap screen, int keyCode) {
        if (screen.getFocused() == this.filterField && keyCode == 28) {
            this.filterField.setText("");
            this.updateSearch();
            return true;
        }
        return false;
    }

    public void mouseScrolled(int direction) {
        this.scroll(direction);
    }

    public void tick() {
        this.filterField.updateCursorCounter();
    }

    public void unfocusAll() {
        if (this.filterField != null) {
            this.filterField.setFocused(false);
        }
    }

    public void onMenuClosed() {
        this.menuOffset = 0;
        this.searchPattern = null;
        this.searchStartPattern = null;
        this.updateFilteredList();
        this.filterField = null;
    }

    private void scroll(int direction) {
        this.menuOffset += direction;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Pattern getSearchStartPattern() {
        return this.searchStartPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilteredList() {
        MapElementRenderProvider<E, C> provider = this.provider;
        if (provider == null) {
            this.filteredElements = null;
            return;
        }
        if (this.filteredElements == null) {
            this.filteredElements = new ArrayList();
        } else {
            this.filteredElements.clear();
        }
        Pattern regex = this.searchPattern;
        Pattern regexStartsWith = this.searchStartPattern;
        this.beforeFiltering();
        provider.begin(4, this.context);
        try {
            while (provider.hasNext(4, this.context)) {
                E e = provider.getNext(4, this.context);
                if (regex == null) {
                    this.filteredElements.add(e);
                    continue;
                }
                String filterName = this.getRenderer(e).getReader().getFilterName(e).toLowerCase();
                if (regexStartsWith.matcher(filterName).find()) {
                    this.filteredElements.add(0, e);
                    continue;
                }
                if (!regex.matcher(filterName).find()) continue;
                this.filteredElements.add(e);
            }
        }
        finally {
            provider.end(4, this.context);
        }
    }

    protected <O> ElementRenderer<? super O, ?, ?> getAnyRenderer(O element) {
        if (element == this.scrollDown || element == this.scrollUp || element == this.extraHitbox) {
            return null;
        }
        return this.getRenderer(element);
    }

    protected abstract ElementRenderer<? super E, ?, ?> getRenderer(E var1);

    public abstract int menuStartPos(int var1);

    public abstract int menuSearchPadding();

    public abstract void renderInMenu(E var1, GuiScreen var2, int var3, int var4, double var5, boolean var7, boolean var8, Minecraft var9, boolean var10, int var11);

    protected abstract String getFilterPlaceholder();

    protected abstract void beforeFiltering();

    public GuiTextField getFilterField() {
        return this.filterField;
    }
}

