/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.entity.util.EntityUtil;
import xaero.map.misc.Misc;

public class ElementRenderInfo {
    public final ElementRenderLocation location;
    public final Entity renderEntity;
    public final Vec3d renderEntityPos;
    public final EntityPlayer player;
    public final Vec3d renderPos;
    public final double mouseX;
    public final double mouseZ;
    public final float brightness;
    public final double scale;
    public final double screenSizeBasedScale;
    public final boolean cave;
    public final float partialTicks;
    public final Framebuffer framebuffer;
    public final ScaledResolution scaledResolution;
    public final double renderEntityDimensionScale;
    public final int renderEntityDimension;
    public final double backgroundCoordinateScale;
    public final int mapDimension;

    public ElementRenderInfo(ElementRenderLocation location, Entity renderEntity, EntityPlayer player, Vec3d renderPos, double mouseX, double mouseZ, double scale, boolean cave, float partialTicks, float brightness, double screenSizeBasedScale, Framebuffer framebuffer, ScaledResolution scaledResolution, double backgroundCoordinateScale, int mapDimension) {
        this.location = location;
        this.renderEntity = renderEntity;
        this.mouseX = mouseX;
        this.mouseZ = mouseZ;
        this.scale = scale;
        this.brightness = brightness;
        this.screenSizeBasedScale = screenSizeBasedScale;
        this.renderEntityPos = EntityUtil.getEntityPos(renderEntity, partialTicks);
        this.player = player;
        this.renderPos = renderPos;
        this.cave = cave;
        this.partialTicks = partialTicks;
        this.framebuffer = framebuffer;
        this.scaledResolution = scaledResolution;
        this.renderEntityDimensionScale = Misc.getDimensionTypeScale((World)Minecraft.getMinecraft().world);
        this.renderEntityDimension = Minecraft.getMinecraft().world.provider.getDimension();
        this.backgroundCoordinateScale = backgroundCoordinateScale;
        this.mapDimension = mapDimension;
    }
}

