/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.server.ServerConfigManager;
import xaero.lib.common.packet.XaeroPacket;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        if (oldPlayer instanceof EntityPlayerMP) {
            EntityPlayer newPlayer = event.getEntityPlayer();
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get((EntityPlayerMP)oldPlayer));
        }
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer());
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            WorldMap.messageHandler.sendToPlayer((EntityPlayerMP)player, (XaeroPacket)new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(EntityPlayerMP player) {
        WorldMap.messageHandler.sendToPlayer(player, (XaeroPacket)new HandshakePacket());
        ServerConfigManager configManager = WorldMap.INSTANCE.getConfigs().getServerConfigManager();
        ConfigProfile defaultEnforcedProfile = configManager.getDefaultEnforcedProfile();
        boolean caveModeConfig = !Boolean.FALSE.equals(defaultEnforcedProfile.get((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED));
        Set caveModeDimensionsConfig = (Set)defaultEnforcedProfile.get(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        boolean allowOverworldCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(0));
        boolean allowNetherCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(-1));
        WorldMap.messageHandler.sendToPlayer(player, (XaeroPacket)new ClientboundRulesPacket(allowOverworldCaveModeOnServer, allowNetherCaveModeOnServer));
        MinecraftServer mcServer = player.world.getMinecraftServer();
        Path propertiesPath = mcServer.getActiveAnvilConverter().getFile(mcServer.getFolderName(), "xaeromap.txt").toPath();
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.getServer());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            if (properties.isUsable()) {
                WorldMap.messageHandler.sendToPlayer(player, (XaeroPacket)properties);
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.connection.disconnect((ITextComponent)new TextComponentTranslation("gui.xaero_wm_error_loading_properties", new Object[0]));
        }
    }

    @SubscribeEvent
    public void handlePlayerTickStart(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            WorldMap.serverPlayerTickHandler.tick((EntityPlayerMP)player);
            return;
        }
    }
}

