/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;

public class MapRenderHelper {
    public static void renderTexturedModalRect(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuffer();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.pos((double)(x + 0.0f), (double)(y + height), 0.0).tex((double)normalizedTextureX, (double)normalizedTextureY2).endVertex();
        vertexBuffer.pos((double)(x + width), (double)(y + height), 0.0).tex((double)normalizedTextureX2, (double)normalizedTextureY2).endVertex();
        vertexBuffer.pos((double)(x + width), (double)(y + 0.0f), 0.0).tex((double)normalizedTextureX2, (double)normalizedTextureY).endVertex();
        vertexBuffer.pos((double)(x + 0.0f), (double)(y + 0.0f), 0.0).tex((double)normalizedTextureX, (double)normalizedTextureY).endVertex();
        tessellator.draw();
    }

    public static void renderDynamicHighlight(int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        int sideColor = MapRenderHelper.getColorInt(sideR, sideG, sideB, sideA);
        int centerColor = MapRenderHelper.getColorInt(centerR, centerG, centerB, centerA);
        Gui.drawRect((int)(leftX - 1 - flooredCameraX), (int)(topZ - 1 - flooredCameraZ), (int)(leftX - flooredCameraX), (int)(bottomZ + 1 - flooredCameraZ), (int)sideColor);
        Gui.drawRect((int)(leftX - flooredCameraX), (int)(topZ - 1 - flooredCameraZ), (int)(rightX - flooredCameraX), (int)(topZ - flooredCameraZ), (int)sideColor);
        Gui.drawRect((int)(rightX - flooredCameraX), (int)(topZ - 1 - flooredCameraZ), (int)(rightX + 1 - flooredCameraX), (int)(bottomZ + 1 - flooredCameraZ), (int)sideColor);
        Gui.drawRect((int)(leftX - flooredCameraX), (int)(bottomZ - flooredCameraZ), (int)(rightX - flooredCameraX), (int)(bottomZ + 1 - flooredCameraZ), (int)sideColor);
        Gui.drawRect((int)(leftX - flooredCameraX), (int)(topZ - flooredCameraZ), (int)(rightX - flooredCameraX), (int)(bottomZ - flooredCameraZ), (int)centerColor);
    }

    public static int getColorInt(float r, float g, float b, float a) {
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(a * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    public static void drawCenteredStringWithBackground(FontRenderer font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha) {
        int stringWidth = font.getStringWidth(string);
        MapRenderHelper.drawStringWithBackground(font, string, x - stringWidth / 2, y, color, bgRed, bgGreen, bgBlue, bgAlpha);
    }

    public static void drawStringWithBackground(FontRenderer font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha) {
        int stringWidth = font.getStringWidth(string);
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)-1.0f);
        Gui.drawRect((int)(x - 1), (int)(y - 1), (int)(x + stringWidth + 1), (int)(y + 9), (int)MapRenderHelper.getColorInt(bgRed, bgGreen, bgBlue, bgAlpha));
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)1.0f);
        font.drawStringWithShadow(string, (float)x, (float)y, color);
    }

    public static void drawCenteredStringWithBackground(FontRenderer font, ITextComponent text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha) {
        MapRenderHelper.drawCenteredStringWithBackground(font, text.getFormattedText(), x, y, color, bgRed, bgGreen, bgBlue, bgAlpha);
    }

    public static void drawStringWithBackground(FontRenderer font, ITextComponent text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha) {
        MapRenderHelper.drawStringWithBackground(font, text.getFormattedText(), x, y, color, bgRed, bgGreen, bgBlue, bgAlpha);
    }
}

