/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Keyboard;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.ScreenBase;
import xaero.map.world.MapDimension;

public class GuiMapName
extends ScreenBase {
    protected String screenTitle;
    private GuiTextField nameTextField;
    private MapDimension mapDimension;
    private String editingMWId;
    private String currentNameFieldContent;
    private MapProcessor mapProcessor;

    public GuiMapName(MapProcessor mapProcessor, GuiScreen par1GuiScreen, GuiScreen escape, MapDimension mapDimension, String editingMWId) {
        super(par1GuiScreen, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_map_name", new Object[0]));
        this.mapDimension = mapDimension;
        this.editingMWId = editingMWId;
        this.currentNameFieldContent = editingMWId == null ? "" : mapDimension.getMultiworldName(editingMWId);
        this.mapProcessor = mapProcessor;
        this.canSkipWorldRender = true;
    }

    public void initGui() {
        super.initGui();
        this.screenTitle = I18n.format((String)"gui.xaero_map_name", (Object[])new Object[0]);
        if (this.nameTextField != null) {
            this.currentNameFieldContent = this.nameTextField.getText();
        }
        this.nameTextField = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, 60, 200, 20);
        this.nameTextField.setText(this.currentNameFieldContent);
        this.nameTextField.setFocused(true);
        this.addButton((GuiButton)new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, I18n.format((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.addButton((GuiButton)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, I18n.format((String)"gui.xaero_cancel", (Object[])new Object[0])));
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.enabled) {
            if (button.id == 200) {
                if (this.canConfirm()) {
                    Object object = this.mapProcessor.uiSync;
                    synchronized (object) {
                        if (this.mapProcessor.getMapWorld() == this.mapDimension.getMapWorld()) {
                            String mwIdFixed;
                            String unfilteredName = this.nameTextField.getText();
                            if (this.editingMWId == null) {
                                String mwId = unfilteredName.toLowerCase().replaceAll("[^a-z0-9]+", "");
                                if (mwId.isEmpty()) {
                                    mwId = "map";
                                }
                                mwId = "cm$" + mwId;
                                boolean mwAdded = false;
                                mwIdFixed = mwId;
                                int fix = 1;
                                while (!mwAdded) {
                                    mwAdded = this.mapDimension.addMultiworldChecked(mwIdFixed);
                                    if (mwAdded) continue;
                                    mwIdFixed = mwId + ++fix;
                                }
                                Path dimensionFolderPath = this.mapDimension.getMainFolderPath();
                                Path multiworldFolderPath = dimensionFolderPath.resolve(mwIdFixed);
                                try {
                                    Files.createDirectories(multiworldFolderPath, new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                                }
                                this.mapDimension.setMultiworldUnsynced(mwIdFixed);
                            } else {
                                mwIdFixed = this.editingMWId;
                            }
                            this.mapDimension.setMultiworldName(mwIdFixed, unfilteredName);
                            this.mapDimension.saveConfigUnsynced();
                            this.goBack();
                        }
                    }
                }
            } else if (button.id == 201) {
                this.goBack();
            }
        }
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private boolean canConfirm() {
        return this.nameTextField.getText().length() > 0;
    }

    private void updateConfirmButton() {
        ((GuiButton)this.buttonList.get((int)0)).enabled = this.canConfirm();
    }

    protected void keyTyped(char par1, int par2) throws IOException {
        super.keyTyped(par1, par2);
        if (this.nameTextField.isFocused()) {
            this.nameTextField.textboxKeyTyped(par1, par2);
            this.updateConfirmButton();
        }
        if ((par2 == 28 || par2 == 156) && this.canConfirm()) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }

    public void updateScreen() {
        this.updateConfirmButton();
        this.nameTextField.updateCursorCounter();
    }

    public void drawScreen(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        this.nameTextField.drawTextBox();
        super.drawScreen(par1, par2, par3);
    }

    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.nameTextField.mouseClicked(par1, par2, par3);
    }
}

