/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.util.KeySortableByOther;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.GuiDimensionOptions;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.gui.YesNoCallbackImplementation;
import xaero.map.world.MapConnectionManager;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;

public class GuiMapSwitching {
    private static final ITextComponent CONNECT_MAP = new TextComponentTranslation("gui.xaero_connect_map", new Object[0]);
    private static final ITextComponent DISCONNECT_MAP = new TextComponentTranslation("gui.xaero_disconnect_map", new Object[0]);
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private DropDownWidget createdDimensionDropdown;
    private DropDownWidget createdMapDropdown;
    private GuiButton switchingButton;
    private GuiButton multiworldTypeOptionButton;
    private GuiButton renameButton;
    private GuiButton connectButton;
    private GuiButton deleteButton;
    private GuiButton confirmButton;
    private Tooltip serverSelectionModeBox = new Tooltip("gui.xaero_mw_server_box");
    private Tooltip mapSelectionBox = new Tooltip("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;
    private boolean uiPausedOnUpdate;
    private boolean mapSwitchingAllowed;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        boolean dimensionDDWasOpen = this.createdDimensionDropdown != null && !this.createdDimensionDropdown.isClosed();
        boolean mapDDWasOpen = this.createdMapDropdown != null && !this.createdMapDropdown.isClosed();
        this.createdDimensionDropdown = null;
        this.createdMapDropdown = null;
        this.switchingButton = null;
        this.multiworldTypeOptionButton = null;
        this.renameButton = null;
        this.deleteButton = null;
        this.confirmButton = null;
        this.settingsDimension = this.mapProcessor.getMapWorld().getFutureDimension();
        this.mapSwitchingAllowed = this.settingsDimension != null;
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            this.uiPausedOnUpdate = this.isUIPaused();
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, height - 20);
            mapScreen.addGuiButton(this.switchingButton);
            if (this.mapSwitchingAllowed) {
                this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
                if (this.active) {
                    this.createdDimensionDropdown = this.createDimensionDropdown(this.uiPausedOnUpdate, width, mapScreen, minecraft);
                    this.createdMapDropdown = this.createMapDropdown(this.uiPausedOnUpdate, width, mapScreen, minecraft);
                    mapScreen.addWidget(this.createdDimensionDropdown);
                    mapScreen.addWidget(this.createdMapDropdown);
                    if (dimensionDDWasOpen) {
                        this.createdDimensionDropdown.setClosed(false);
                    }
                    if (mapDDWasOpen) {
                        this.createdMapDropdown.setClosed(false);
                    }
                    this.multiworldTypeOptionButton = new TooltipButton(width / 2 - 90, 24, 180, 20, this.getMultiworldTypeButtonMessage(), new Supplier<Tooltip>(){

                        @Override
                        public Tooltip get() {
                            return GuiMapSwitching.this.settingsDimension.isFutureMultiworldServerBased() ? GuiMapSwitching.this.serverSelectionModeBox : GuiMapSwitching.this.mapSelectionBox;
                        }
                    }){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void onPress() {
                            Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiPauseSync;
                            synchronized (object) {
                                if (GuiMapSwitching.this.isMapSelectionOptionEnabled()) {
                                    GuiMapSwitching.this.mapProcessor.toggleMultiworldType(GuiMapSwitching.this.settingsDimension);
                                    ((GuiMapSwitching)GuiMapSwitching.this).multiworldTypeOptionButton.displayString = GuiMapSwitching.this.getMultiworldTypeButtonMessage();
                                }
                            }
                        }
                    };
                    mapScreen.addGuiButton(this.multiworldTypeOptionButton);
                    this.renameButton = new GuiButton(-1, width / 2 + 109, 80, 60, 20, I18n.format((String)"gui.xaero_rename", (Object[])new Object[0]));
                    mapScreen.addGuiButton(this.renameButton);
                    this.connectButton = new GuiButton(-1, width / 2 + 109, 102, 60, 20, this.getConnectButtonLabel());
                    mapScreen.addGuiButton(this.connectButton);
                    this.deleteButton = new GuiButton(-1, width / 2 - 168, 80, 60, 20, I18n.format((String)"gui.xaero_delete", (Object[])new Object[0]));
                    mapScreen.addGuiButton(this.deleteButton);
                    this.confirmButton = new GuiButton(200, width / 2 - 50, 104, 100, 20, I18n.format((String)"gui.xaero_confirm", (Object[])new Object[0]));
                    mapScreen.addGuiButton(this.confirmButton);
                    this.updateButtons(mapScreen, width, minecraft);
                } else {
                    this.switchingButton.enabled = this.canToggleThisScreen();
                }
            } else {
                this.switchingButton.enabled = false;
            }
        }
    }

    public static GuiDimensionOptions getSortedDimensionOptions(MapDimension dim) {
        int selected = 0;
        Integer currentDim = dim.getDimId();
        ArrayList sortableList = new ArrayList();
        for (MapDimension dimension : dim.getMapWorld().getDimensionsList()) {
            sortableList.add(new KeySortableByOther((Object)dimension.getDimId(), new Comparable[]{dimension.getDropdownLabel()}));
        }
        Collections.sort(sortableList);
        selected = GuiMapSwitching.getDropdownSelectionIdFromValue(sortableList, currentDim);
        Integer[] objectValues = sortableList.stream().map(new Function<KeySortableByOther<Integer>, Integer>(){

            @Override
            public Integer apply(KeySortableByOther<Integer> ks) {
                return (Integer)ks.getKey();
            }
        }).collect(new Supplier<ArrayList<Integer>>(){

            @Override
            public ArrayList<Integer> get() {
                return new ArrayList<Integer>();
            }
        }, new BiConsumer<ArrayList<Integer>, Integer>(){

            @Override
            public void accept(ArrayList<Integer> al, Integer e) {
                al.add(e);
            }
        }, new BiConsumer<ArrayList<Integer>, ArrayList<Integer>>(){

            @Override
            public void accept(ArrayList<Integer> al, ArrayList<Integer> al2) {
                al.addAll(al2);
            }
        }).toArray(new Integer[0]);
        int[] values = new int[objectValues.length];
        for (int i = 0; i < objectValues.length; ++i) {
            values[i] = objectValues[i];
        }
        return new GuiDimensionOptions(selected, values);
    }

    private DropDownWidget createDimensionDropdown(boolean paused, final int width, final GuiMap mapScreen, final Minecraft minecraft) {
        GuiDimensionOptions dimOptions = GuiMapSwitching.getSortedDimensionOptions(this.settingsDimension);
        ArrayList<String> dropdownLabels = new ArrayList<String>();
        final int currentWorldDim = this.mapProcessor.getWorld() == null ? 0 : this.mapProcessor.getWorld().provider.getDimension();
        for (int k : dimOptions.values) {
            MapDimension dim = this.settingsDimension.getMapWorld().getDimension(k);
            String result = dim.getDropdownLabel();
            if (k == currentWorldDim) {
                result = result + " (auto)";
            }
            dropdownLabels.add(result);
        }
        final int[] finalValues = dimOptions.values;
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(dropdownLabels.toArray(new String[0])).setX(width / 2 - 100).setY(64).setW(200).setSelected(Integer.valueOf(dimOptions.selected)).setCallback(new IDropDownWidgetCallback(){

            public boolean onSelected(DropDownWidget dd, int i) {
                Integer selectedValue = finalValues[i];
                GuiMapSwitching.this.settingsDimension = GuiMapSwitching.this.settingsDimension.getMapWorld().getDimension(selectedValue);
                if (selectedValue == currentWorldDim) {
                    selectedValue = null;
                }
                GuiMapSwitching.this.settingsDimension.getMapWorld().setCustomDimensionId(selectedValue);
                GuiMapSwitching.this.mapProcessor.checkForWorldUpdate();
                DropDownWidget newDropDown = GuiMapSwitching.this.createMapDropdown(GuiMapSwitching.this.uiPausedOnUpdate, width, mapScreen, minecraft);
                mapScreen.replaceWidget((GuiButton)GuiMapSwitching.this.createdMapDropdown, (GuiButton)newDropDown);
                GuiMapSwitching.this.createdMapDropdown = newDropDown;
                GuiMapSwitching.this.updateButtons(mapScreen, width, minecraft);
                return true;
            }
        }).setContainer((IDropDownContainer)mapScreen).build();
        return result;
    }

    private DropDownWidget createMapDropdown(boolean paused, final int width, final GuiMap mapScreen, final Minecraft minecraft) {
        ArrayList<String> mwDropdownNames;
        int selected = 0;
        if (!paused) {
            int currentIndex;
            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
            ArrayList sortableList = new ArrayList();
            for (String mwId : this.settingsDimension.getMultiworldIdsCopy()) {
                sortableList.add(new KeySortableByOther((Object)mwId, new Comparable[]{this.settingsDimension.getMultiworldName(mwId).toLowerCase()}));
            }
            if (currentMultiworld != null && (currentIndex = GuiMapSwitching.getDropdownSelectionIdFromValue(sortableList, currentMultiworld)) == -1) {
                sortableList.add(new KeySortableByOther((Object)currentMultiworld, new Comparable[]{this.settingsDimension.getMultiworldName(currentMultiworld).toLowerCase()}));
            }
            Collections.sort(sortableList);
            if (currentMultiworld != null) {
                selected = GuiMapSwitching.getDropdownSelectionIdFromValue(sortableList, currentMultiworld);
            }
            ArrayList<Object> dropdownValuesList = new ArrayList<Object>();
            mwDropdownNames = new ArrayList();
            for (KeySortableByOther keySortableByOther : sortableList) {
                dropdownValuesList.add(keySortableByOther.getKey());
                mwDropdownNames.add(this.settingsDimension.getMultiworldName((String)keySortableByOther.getKey()));
            }
            this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
            mwDropdownNames.add("\u00a78" + I18n.format((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
        } else {
            mwDropdownNames = new ArrayList<String>();
            this.mwDropdownValues = null;
            mwDropdownNames.add("\u00a77" + I18n.format((String)"gui.xaero_map_menu_please_wait", (Object[])new Object[0]));
        }
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(mwDropdownNames.toArray(new String[0])).setX(width / 2 - 100).setY(84).setW(200).setSelected(Integer.valueOf(selected)).setCallback(new IDropDownWidgetCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onSelected(DropDownWidget dd, int i) {
                Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (GuiMapSwitching.this.isUIPaused() || GuiMapSwitching.this.uiPausedOnUpdate) {
                        return false;
                    }
                    if (i < GuiMapSwitching.this.mwDropdownValues.length) {
                        GuiMapSwitching.this.mapProcessor.setMultiworld(GuiMapSwitching.this.settingsDimension, GuiMapSwitching.this.mwDropdownValues[i]);
                        GuiMapSwitching.this.updateButtons(mapScreen, width, minecraft);
                        return true;
                    }
                    minecraft.displayGuiScreen((GuiScreen)new GuiMapName(GuiMapSwitching.this.mapProcessor, (GuiScreen)mapScreen, (GuiScreen)mapScreen, GuiMapSwitching.this.settingsDimension, null));
                    return false;
                }
            }
        }).setContainer((IDropDownContainer)mapScreen).build();
        result.setActive(!paused);
        return result;
    }

    private boolean isUIPaused() {
        return this.mapProcessor.isUIPaused() || this.mapProcessor.isWaitingForWorldUpdate();
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canToggleThisScreen() {
        return !this.isUIPaused() && this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
    }

    private boolean canDeleteMap() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureUsingWorldSaveUnsynced() && this.mwDropdownValues != null && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private boolean canRenameMap() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureUsingWorldSaveUnsynced();
    }

    private boolean canConnectMap() {
        if (!this.mapProcessor.getMapWorld().isMultiplayer()) {
            return false;
        }
        MapConnectionNode playerMapKey = this.settingsDimension.getMapWorld().getPlayerMapKey();
        if (playerMapKey == null) {
            return false;
        }
        MapConnectionNode destinationMapKey = this.settingsDimension.getSelectedMapKeyUnsynced();
        if (destinationMapKey == null) {
            return false;
        }
        return !destinationMapKey.equals(playerMapKey);
    }

    private boolean canConfirm() {
        return !this.isUIPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConnectButtonLabel() {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            if (this.isUIPaused()) {
                return CONNECT_MAP.getFormattedText();
            }
            MapConnectionNode playerMapKey = this.settingsDimension.getMapWorld().getPlayerMapKey();
            if (playerMapKey == null) {
                return CONNECT_MAP.getFormattedText();
            }
            MapConnectionNode destinationMapKey = this.settingsDimension.getSelectedMapKeyUnsynced();
            if (destinationMapKey == null) {
                return CONNECT_MAP.getFormattedText();
            }
            MapConnectionManager mapConnections = this.settingsDimension.getMapWorld().getMapConnections();
            if (mapConnections.isConnected(playerMapKey, destinationMapKey)) {
                return DISCONNECT_MAP.getFormattedText();
            }
            return CONNECT_MAP.getFormattedText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons(GuiMap mapScreen, int width, Minecraft minecraft) {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            boolean isPaused = this.isUIPaused();
            if (this.uiPausedOnUpdate != isPaused) {
                DropDownWidget newDropDown;
                DropDownWidget dropDownWidget = newDropDown = !this.active ? null : this.createMapDropdown(isPaused, width, mapScreen, minecraft);
                if (newDropDown != null) {
                    if (this.createdMapDropdown != null) {
                        mapScreen.replaceWidget((GuiButton)this.createdMapDropdown, (GuiButton)newDropDown);
                    } else {
                        mapScreen.addWidget(newDropDown);
                    }
                } else if (this.createdMapDropdown != null) {
                    mapScreen.removeWidget((GuiButton)this.createdMapDropdown);
                }
                this.createdMapDropdown = !this.active ? null : newDropDown;
                this.uiPausedOnUpdate = isPaused;
            }
            this.switchingButton.enabled = this.canToggleThisScreen();
            if (this.deleteButton != null) {
                this.deleteButton.enabled = this.canDeleteMap();
            }
            if (this.renameButton != null) {
                this.renameButton.enabled = this.canRenameMap();
            }
            if (this.connectButton != null) {
                this.connectButton.enabled = this.canConnectMap();
                this.connectButton.displayString = this.getConnectButtonLabel();
            }
            if (this.multiworldTypeOptionButton != null) {
                this.multiworldTypeOptionButton.enabled = this.isMapSelectionOptionEnabled();
            }
            if (this.confirmButton != null) {
                this.confirmButton.enabled = this.canConfirm();
            }
        }
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.format((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.format((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.setWorldAndResolution(minecraft, width, height);
        }
    }

    private static <S> int getDropdownSelectionIdFromValue(List<KeySortableByOther<S>> values, S value) {
        for (int selected = 0; selected < values.size(); ++selected) {
            if (!values.get(selected).getKey().equals(value)) continue;
            return selected;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMapRender(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.setWorldAndResolution(minecraft, width, height);
        }
        if (this.mapSwitchingAllowed && (this.createdMapDropdown == null || this.createdMapDropdown.isClosed())) {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.uiPausedOnUpdate != this.isUIPaused()) {
                    this.updateButtons(mapScreen, width, minecraft);
                }
            }
        }
        if (this.active && this.settingsDimension != null && this.createdMapDropdown.isClosed() && !this.uiPausedOnUpdate && (currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()) != null && (!currentMultiworld.equals(currentDropdownSelection = this.mwDropdownValues[this.createdMapDropdown.getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.setWorldAndResolution(minecraft, width, height);
        }
    }

    public void renderText(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.format((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        MapRenderHelper.drawStringWithBackground(minecraft.fontRenderer, selectMapString, width / 2 - minecraft.fontRenderer.getStringWidth(selectMapString) / 2, 49, -1, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public void postMapRender(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(final GuiMap mapScreen, final Minecraft minecraft, int width, int height, final GuiButton b) {
        if (b.enabled) {
            if (b == this.switchingButton) {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canToggleThisScreen()) {
                        return;
                    }
                    this.active = !this.active;
                    mapScreen.setWorldAndResolution(minecraft, width, height);
                }
            }
            if (b == this.renameButton) {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canRenameMap()) {
                        return;
                    }
                    String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
                    if (currentMultiworld == null) {
                        return;
                    }
                    minecraft.displayGuiScreen((GuiScreen)new GuiMapName(this.mapProcessor, (GuiScreen)mapScreen, (GuiScreen)mapScreen, this.settingsDimension, currentMultiworld));
                }
            }
            if (b == this.connectButton) {
                if (!this.canConnectMap()) {
                    return;
                }
                final MapConnectionNode playerMapKey = this.settingsDimension.getMapWorld().getPlayerMapKey();
                if (playerMapKey == null) {
                    return;
                }
                final MapConnectionNode destinationMapKey = this.settingsDimension.getSelectedMapKeyUnsynced();
                if (destinationMapKey == null) {
                    return;
                }
                String autoMapName = playerMapKey.getNamedString(this.settingsDimension.getMapWorld());
                String selectedMapName = destinationMapKey.getNamedString(this.settingsDimension.getMapWorld());
                String connectionDisplayString = autoMapName + "   \u00a7e<=>\u00a7r   " + selectedMapName;
                final MapConnectionManager mapConnections = this.settingsDimension.getMapWorld().getMapConnections();
                final boolean connected = mapConnections.isConnected(playerMapKey, destinationMapKey);
                GuiYesNoCallback confirmationConsumer = new GuiYesNoCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void confirmClicked(boolean result, int id) {
                        if (result) {
                            Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiSync;
                            synchronized (object) {
                                if (connected) {
                                    mapConnections.removeConnection(playerMapKey, destinationMapKey);
                                } else {
                                    mapConnections.addConnection(playerMapKey, destinationMapKey);
                                }
                                b.displayString = GuiMapSwitching.this.getConnectButtonLabel();
                                GuiMapSwitching.this.settingsDimension.getMapWorld().saveConfig();
                            }
                        }
                        minecraft.displayGuiScreen((GuiScreen)mapScreen);
                    }
                };
                if (connected) {
                    minecraft.displayGuiScreen((GuiScreen)new GuiYesNo(confirmationConsumer, I18n.format((String)"gui.xaero_wm_disconnect_from_auto_msg", (Object[])new Object[0]), connectionDisplayString, 0));
                } else {
                    minecraft.displayGuiScreen((GuiScreen)new GuiYesNo(confirmationConsumer, I18n.format((String)"gui.xaero_wm_connect_with_auto_msg", (Object[])new Object[0]), connectionDisplayString, 0));
                }
            } else {
                if (b == this.deleteButton) {
                    Object object = this.mapProcessor.uiPauseSync;
                    synchronized (object) {
                        if (!this.canDeleteMap()) {
                            return;
                        }
                        final String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                        minecraft.displayGuiScreen((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                            @Override
                            public void confirmClicked(boolean result, int id) {
                                if (result) {
                                    String mapNameAndIdLine = I18n.format((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + GuiMapSwitching.this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                    minecraft.displayGuiScreen((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void confirmClicked(boolean result2, int id) {
                                            if (result2) {
                                                Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiSync;
                                                synchronized (object) {
                                                    if (GuiMapSwitching.this.mapProcessor.getMapWorld() == GuiMapSwitching.this.settingsDimension.getMapWorld()) {
                                                        MapDimension currentDimension;
                                                        MapDimension mapDimension = currentDimension = !GuiMapSwitching.this.mapProcessor.isMapWorldUsable() ? null : GuiMapSwitching.this.mapProcessor.getMapWorld().getCurrentDimension();
                                                        if (GuiMapSwitching.this.settingsDimension == currentDimension && GuiMapSwitching.this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                            if (WorldMapClientConfigUtils.getDebug()) {
                                                                WorldMap.LOGGER.info("Delayed map deletion!");
                                                            }
                                                            GuiMapSwitching.this.mapProcessor.requestCurrentMapDeletion();
                                                        } else {
                                                            if (WorldMapClientConfigUtils.getDebug()) {
                                                                WorldMap.LOGGER.info("Instant map deletion!");
                                                            }
                                                            GuiMapSwitching.this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                        }
                                                        GuiMapSwitching.this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                        GuiMapSwitching.this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                        GuiMapSwitching.this.settingsDimension.saveConfigUnsynced();
                                                        ((GuiMapSwitching)GuiMapSwitching.this).settingsDimension.futureMultiworldWritable = false;
                                                    }
                                                }
                                            }
                                            minecraft.displayGuiScreen((GuiScreen)mapScreen);
                                        }
                                    }, I18n.format((String)"gui.xaero_delete_map_msg3", (Object[])new Object[0]), mapNameAndIdLine, -1));
                                } else {
                                    minecraft.displayGuiScreen((GuiScreen)mapScreen);
                                }
                            }
                        }, I18n.format((String)"gui.xaero_delete_map_msg1", (Object[])new Object[0]), I18n.format((String)"gui.xaero_delete_map_msg2", (Object[])new Object[0]), -1));
                    }
                }
                if (b.id == 200) {
                    Object object = this.mapProcessor.uiPauseSync;
                    synchronized (object) {
                        if (!this.canConfirm()) {
                            return;
                        }
                        this.confirm(mapScreen, minecraft, width, height);
                    }
                }
            }
        }
    }
}

