/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public abstract class MySlider
extends GuiButton {
    protected double sliderValue = 1.0;
    protected boolean dragging;
    protected int scaledScreenWidth;

    public MySlider(int p_i45017_1_, int p_i45017_2_, int p_i45017_3_, int w, int h, float p_i45017_5_, float p_i45017_6_, int scaledScreenWidth) {
        super(p_i45017_1_, p_i45017_2_, p_i45017_3_, w, h, "");
        this.scaledScreenWidth = scaledScreenWidth;
    }

    protected int getHoverState(boolean mouseOver) {
        return 0;
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            if (this.dragging) {
                this.updateValue(mc, mouseX);
            }
            mc.getTextureManager().bindTexture(BUTTON_TEXTURES);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.x + (int)(this.sliderValue * (double)(this.width - 8)), this.y, 0, 66, 4, 20);
            this.drawTexturedModalRect(this.x + (int)(this.sliderValue * (double)(this.width - 8)) + 4, this.y, 196, 66, 4, 20);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (super.mousePressed(mc, mouseX, mouseY)) {
            this.updateValue(mc, mouseX);
            this.dragging = true;
            return true;
        }
        return false;
    }

    private void updateValue(Minecraft mc, int mouseX) {
        double actualMouseX = (double)Mouse.getX() / (double)mc.displayWidth * (double)this.scaledScreenWidth;
        double partialMouseX = actualMouseX - (double)((int)actualMouseX);
        double finalMouseX = (double)mouseX + partialMouseX;
        this.sliderValue = (finalMouseX - (double)(this.x + 4)) / (double)(this.width - 8);
        this.sliderValue = MathHelper.clamp((double)this.sliderValue, (double)0.0, (double)1.0);
        this.applyValue();
        this.updateMessage();
    }

    protected abstract void applyValue();

    protected abstract void updateMessage();

    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
    }
}

