/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.tracker;

import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.common.packet.XaeroPacket;
import xaero.map.WorldMapSession;

public class ClientboundTrackedPlayerPacket
extends XaeroPacket {
    private boolean remove;
    private UUID id;
    private double x;
    private double y;
    private double z;
    private int dimension;

    public ClientboundTrackedPlayerPacket(boolean remove, UUID id, double x, double y, double z, int dimension) {
        this.remove = remove;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public ClientboundTrackedPlayerPacket() {
    }

    public void read(PacketBuffer buffer) {
        NBTTagCompound nbt;
        try {
            nbt = buffer.readCompoundTag();
        }
        catch (IOException e) {
            return;
        }
        this.remove = nbt.getBoolean("r");
        this.id = nbt.getUniqueId("i");
        if (!this.remove) {
            this.x = nbt.getDouble("x");
            this.y = nbt.getDouble("y");
            this.z = nbt.getDouble("z");
            this.dimension = nbt.getInteger("d");
        }
    }

    public void write(PacketBuffer buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setBoolean("r", this.remove);
        nbt.setUniqueId("i", this.id);
        if (!this.remove) {
            nbt.setDouble("x", this.x);
            nbt.setDouble("y", this.y);
            nbt.setDouble("z", this.z);
            nbt.setInteger("d", this.dimension);
        }
        buffer.writeCompoundTag(nbt);
    }

    public static class Handler
    implements Consumer<ClientboundTrackedPlayerPacket> {
        @Override
        public void accept(ClientboundTrackedPlayerPacket t) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            if (t.remove) {
                session.getMapProcessor().getClientSyncedTrackedPlayerManager().remove(t.id);
                return;
            }
            session.getMapProcessor().getClientSyncedTrackedPlayerManager().update(t.id, t.x, t.y, t.z, t.dimension);
        }
    }
}

