/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;
    private GuiButton renderWaypointsButton;
    private GuiButton showDisabledButton;
    private GuiButton closeMenuWhenHoppingButton;
    private GuiButton currentMapWaypointsButton;
    private GuiButton renderAllSetsButton;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(final GuiMap screen, Minecraft mc, final int width, final int height, final WaypointWorld waypointWorld, final IXaeroMinimap modMain, final XaeroMinimapSession minimapSession) {
        DropDownWidget setsDropdown;
        super.onMapInit(screen, mc, width, height);
        final boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
        final GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
        IDropDownWidgetCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = new IDropDownWidgetCallback(){

                public boolean onSelected(DropDownWidget menu, int selected) {
                    if (canCreate && selected == menu.size() - 1) {
                        GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (GuiScreen)screen, (GuiScreen)screen, waypointWorld);
                        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)guiNewSet);
                        return false;
                    }
                    sets.setCurrentSet(selected);
                    waypointWorld.setCurrent(sets.getCurrentSetKey());
                    minimapSession.getWaypointsManager().updateWaypoints();
                    try {
                        modMain.getSettings().saveWaypoints(waypointWorld);
                    }
                    catch (IOException e) {
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                    return true;
                }
            };
        }
        DropDownWidget dropDownWidget = setsDropdown = sets == null ? null : DropDownWidget.Builder.begin().setOptions(sets.getOptions()).setX(width - 173).setY(height - 56).setW(151).setSelected(Integer.valueOf(sets.getCurrentSet())).setCallback(setsDropdownCallback).setContainer((IDropDownContainer)screen).setOpeningUp(true).build();
        if (setsDropdown != null) {
            screen.addWidget(setsDropdown);
        }
        TextComponentTranslation fullWaypointMenuTooltipText = new TextComponentTranslation("gui.xaero_box_full_waypoints_menu", new Object[]{new TextComponentString(KeyMappingUtils.getKeyName((KeyBinding)ModSettings.keyWaypoints)).setStyle(new Style().setColor(TextFormatting.DARK_GREEN))});
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean renderWaypoints = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean onlyCurrentMapWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        boolean showDisabledWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        boolean closeWaypointsWhenHopping = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        final Tooltip fullWaypointMenuTooltip = new Tooltip((ITextComponent)fullWaypointMenuTooltipText, true);
        final Tooltip onlyCurrentMapWaypointsTooltip = new Tooltip(onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", null, true);
        final Tooltip renderingWaypointsTooltip = new Tooltip((ITextComponent)new TextComponentTranslation(renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints", new Object[]{new TextComponentString(KeyMappingUtils.getKeyName((KeyBinding)ModSettings.keyToggleMapWaypoints)).setStyle(new Style().setColor(TextFormatting.DARK_GREEN))}), true);
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean renderAllSetsConfig = (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ALL_SETS);
        final Tooltip renderAllSetsTooltip = new Tooltip((ITextComponent)new TextComponentTranslation(!renderAllSetsConfig ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets", new Object[]{new TextComponentString(KeyMappingUtils.getKeyName((KeyBinding)ModSettings.keyAllSets)).setStyle(new Style().setColor(TextFormatting.DARK_GREEN))}), true);
        final Tooltip showingDisabledTooltip = new Tooltip(showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", null, true);
        final Tooltip closeWhenHoppingTooltip = new Tooltip(closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", null, true);
        screen.addGuiButton((GuiButton)new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onFullMenuButton(b, screen);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return fullWaypointMenuTooltip;
            }
        }));
        this.currentMapWaypointsButton = new GuiTexturedButton(width - 153, height - 20, 20, 20, onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onCurrentMapWaypointsButton(b, screen, width, height);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return onlyCurrentMapWaypointsTooltip;
            }
        });
        screen.addGuiButton(this.currentMapWaypointsButton);
        this.renderWaypointsButton = new GuiTexturedButton(width - 133, height - 20, 20, 20, renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onRenderWaypointsButton(screen, width, height);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return renderingWaypointsTooltip;
            }
        });
        screen.addGuiButton(this.renderWaypointsButton);
        this.renderAllSetsButton = new GuiTexturedButton(width - 113, height - 20, 20, 20, !renderAllSetsConfig ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onRenderAllSetsButton(b, screen, width, height);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return renderAllSetsTooltip;
            }
        });
        screen.addGuiButton(this.renderAllSetsButton);
        this.showDisabledButton = new GuiTexturedButton(width - 93, height - 20, 20, 20, showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onShowDisabledButton(b, screen, width, height);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return showingDisabledTooltip;
            }
        });
        screen.addGuiButton(this.showDisabledButton);
        this.closeMenuWhenHoppingButton = new GuiTexturedButton(width - 73, height - 20, 20, 20, closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onCloseMenuWhenHoppingButton(b, screen, width, height);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return closeWhenHoppingTooltip;
            }
        });
        screen.addGuiButton(this.closeMenuWhenHoppingButton);
        this.renderWaypointsButton.enabled = !WorldMapClientConfigUtils.isOptionServerEnforced((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        screen.setWorldAndResolution(this.mc, width, height);
    }

    private void onFullMenuButton(GuiButton b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(GuiButton b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
    }

    private void onShowDisabledButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        screen.setWorldAndResolution(this.mc, width, height);
    }

    private void onCloseMenuWhenHoppingButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        screen.setWorldAndResolution(this.mc, width, height);
    }

    private void onCurrentMapWaypointsButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        screen.setWorldAndResolution(this.mc, width, height);
    }

    @Override
    public void renderInMenu(Waypoint element, GuiScreen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        GlStateManager.translate((float)-4.0f, (float)-4.0f, (float)0.0f);
        GlStateManager.enableBlend();
        if (type == 1) {
            Gui.drawRect((int)0, (int)0, (int)9, (int)9, (int)color);
            mc.getTextureManager().bindTexture(Waypoint.minimapTextures);
            ITextureObject texture = mc.getTextureManager().getTexture(Waypoint.minimapTextures);
            texture.setBlurMipmap(false, false);
            GlStateManager.color((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.drawTexturedModalRect(1, 1, 0, 78, 9, 9);
            GlStateManager.color((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.drawTexturedModalRect(0, 0, 0, 78, 9, 9);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.disableTexture2D();
            Gui.drawRect((int)0, (int)0, (int)9, (int)9, (int)color);
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type != 1) {
            mc.fontRenderer.drawStringWithShadow(symbol, (float)(5 - mc.fontRenderer.getStringWidth(symbol) / 2), 1.0f, -1);
        }
        GlStateManager.enableBlend();
        int infoIconOffset = 10;
        if (disabled) {
            GlStateManager.enableTexture2D();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Minecraft.getMinecraft().getTextureManager().bindTexture(WorldMap.guiTextures);
            gui.drawTexturedModalRect(textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += 10;
        }
        if (temporary) {
            GlStateManager.enableTexture2D();
            GlStateManager.color((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.getMinecraft().getTextureManager().bindTexture(WorldMap.guiTextures);
            gui.drawTexturedModalRect(textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += 10;
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected ElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

