/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.icon.XaeroIconAtlasManager;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.getMinecraft();
    private XaeroIcon deathSymbolTexture;
    private final Map<String, XaeroIcon> charSymbols = new HashMap<String, XaeroIcon>();
    private XaeroIconAtlasManager iconManager;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private XaeroIconAtlas lastAtlas;

    public XaeroIcon getDeathSymbolTexture(ScaledResolution scaledRes) {
        if (this.deathSymbolTexture == null) {
            this.createDeathSymbolTexture(scaledRes);
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture(ScaledResolution scaledRes) {
        this.deathSymbolTexture = this.createCharSymbol(true, null, scaledRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XaeroIcon getSymbolTexture(String c, ScaledResolution scaledRes) {
        XaeroIcon icon;
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            icon = this.charSymbols.get(c);
        }
        if (icon == null) {
            icon = this.createCharSymbol(false, c, scaledRes);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XaeroIcon createCharSymbol(boolean death, String c, ScaledResolution scaledRes) {
        if (this.iconManager == null) {
            OpenGLException.checkGLError();
            int maxTextureSize = GlStateManager.glGetInteger((int)3379);
            OpenGLException.checkGLError();
            int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
            this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
            OpenGLException.checkGLError();
            GlStateManager.deleteTexture((int)this.atlasRenderFramebuffer.getFramebufferTexture());
            OpenGLException.checkGLError();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
            this.iconManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        }
        XaeroIconAtlas atlas = this.iconManager.getCurrentAtlas();
        XaeroIcon icon = atlas.createIcon();
        this.atlasRenderFramebuffer.bindFramebuffer(false);
        GlStateManager.viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
        this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
        this.atlasRenderFramebuffer.checkFramebufferComplete();
        if (this.lastAtlas != atlas) {
            GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.clear((int)16384);
            this.lastAtlas = atlas;
        }
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1000.0);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.translate((float)2.0f, (float)2.0f, (float)0.0f);
        if (!death) {
            GlStateManager.scale((float)3.0f, (float)3.0f, (float)1.0f);
            this.mc.fontRenderer.drawStringWithShadow(c, 0.0f, 0.0f, -1);
        } else {
            GlStateManager.scale((float)3.0f, (float)3.0f, (float)1.0f);
            GlStateManager.enableAlpha();
            this.mc.getTextureManager().bindTexture(minimapTextures);
            ITextureObject texture = this.mc.getTextureManager().getTexture(minimapTextures);
            texture.setBlurMipmap(false, false);
            GlStateManager.color((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Gui.drawModalRectWithCustomSizedTexture((int)1, (int)1, (float)0.0f, (float)78.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            GlStateManager.color((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Gui.drawModalRectWithCustomSizedTexture((int)0, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.matrixMode((int)5889);
        Misc.minecraftOrtho(scaledRes);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        this.atlasRenderFramebuffer.unbindFramebuffer();
        this.mc.getFramebuffer().bindFramebuffer(false);
        GlStateManager.viewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        if (death) {
            this.deathSymbolTexture = icon;
        } else {
            Map<String, XaeroIcon> map = this.charSymbols;
            synchronized (map) {
                this.charSymbols.put(c, icon);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            this.charSymbols.clear();
        }
        this.lastAtlas = null;
        this.deathSymbolTexture = null;
        if (this.iconManager != null) {
            this.iconManager.clearAtlases();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
        }
    }
}

