/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;

public class TrackedPlayerIconPrerenderer {
    private ImprovedFramebuffer renderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private final PlayerTrackerIconRenderer renderer = new PlayerTrackerIconRenderer();

    public void prerender(XaeroIcon icon, EntityPlayer player, int iconWidth, ResourceLocation skinTextureLocation, PlayerTrackerMapElement<?> mapElement, ScaledResolution scaledRes) {
        if (this.renderFramebuffer == null) {
            this.renderFramebuffer = new ImprovedFramebuffer(icon.getTextureAtlas().getWidth(), icon.getTextureAtlas().getWidth(), false);
            GlStateManager.deleteTexture((int)this.renderFramebuffer.getFramebufferTexture());
            this.renderFramebuffer.setFramebufferTexture(0);
        }
        this.renderFramebuffer.bindFramebuffer(false);
        GlStateManager.viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)iconWidth, (int)iconWidth);
        this.renderFramebuffer.setFramebufferTexture(icon.getTextureAtlas().getTextureId());
        this.renderFramebuffer.checkFramebufferComplete();
        if (this.lastAtlas != icon.getTextureAtlas()) {
            GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.clear((int)16384);
            this.lastAtlas = icon.getTextureAtlas();
        }
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)iconWidth, (double)iconWidth, (double)0.0, (double)-1.0, (double)1000.0);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.translate((float)(iconWidth / 2), (float)(iconWidth / 2), (float)0.0f);
        GlStateManager.scale((float)3.0f, (float)3.0f, (float)1.0f);
        Gui.drawRect((int)-5, (int)-5, (int)5, (int)5, (int)-1);
        this.renderer.renderIcon(player, skinTextureLocation);
        Minecraft mc = Minecraft.getMinecraft();
        GlStateManager.matrixMode((int)5889);
        Misc.minecraftOrtho(scaledRes);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        this.renderFramebuffer.unbindFramebuffer();
        mc.getFramebuffer().bindFramebuffer(false);
        GlStateManager.viewport((int)0, (int)0, (int)mc.displayWidth, (int)mc.displayHeight);
    }
}

