/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO = new ImprovedFramebuffer(64, 64, false);
    private int glEmptyTexture;

    public BranchTextureRenderer(Framebuffer defaultFramebuffer) {
        this.glEmptyTexture = this.renderFBO.framebufferTexture;
        this.renderFBO.bindFramebuffer(true);
        GlStateManager.disableAlpha();
        GlStateManager.disableBlend();
        GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.clear((int)16384);
        GlStateManager.enableAlpha();
        GlStateManager.enableBlend();
        this.renderFBO.unbindFramebuffer();
        defaultFramebuffer.bindFramebuffer(true);
    }

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, Framebuffer defaultFramebuffer, boolean justAllocated, ScaledResolution scaledRes) {
        GlStateManager.bindTexture((int)0);
        this.renderFBO.bindFramebuffer(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1.0);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.disableAlpha();
        GlStateManager.disableBlend();
        if (justAllocated) {
            GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.clear((int)16384);
        }
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1);
        }
        OpenGLException.checkGLError(false, "updating a map branch texture");
        GlStateManager.enableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.bindTexture((int)0);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5889);
        Minecraft mc = Minecraft.getMinecraft();
        Misc.minecraftOrtho(scaledRes);
        GlStateManager.matrixMode((int)5888);
        this.renderFBO.unbindFramebuffer();
        mc.getFramebuffer().bindFramebuffer(false);
        GlStateManager.viewport((int)0, (int)0, (int)mc.displayWidth, (int)mc.displayHeight);
        OpenGLException.checkGLError();
    }

    private void renderCorner(Integer srcTexture, int cornerX, int cornerY) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        GlStateManager.bindTexture((int)(srcTexture != -1 ? srcTexture : this.glEmptyTexture));
        MapRenderHelper.renderTexturedModalRect(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f);
    }
}

