/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.teleport;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapTeleporter {
    public void teleport(GuiScreen screen, MapWorld mapWorld, int x, int y, int z, Integer d) {
        String tpCommand;
        Minecraft.getMinecraft().displayGuiScreen(null);
        if (Minecraft.getMinecraft().playerController.gameIsSurvivalOrAdventure()) {
            MapConnectionNode destinationMapKey;
            MapDimension destinationDim = mapWorld.getDimension(d != null ? d.intValue() : Minecraft.getMinecraft().world.provider.getDimension());
            MapConnectionNode playerMapKey = mapWorld.getPlayerMapKey();
            if (playerMapKey == null) {
                TextComponentString messageComponent = new TextComponentString(I18n.format((String)"gui.xaero_wm_teleport_never_confirmed", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().setColor(TextFormatting.RED));
                Minecraft.getMinecraft().ingameGUI.getChatGUI().printChatMessage((ITextComponent)messageComponent);
                return;
            }
            MapConnectionNode mapConnectionNode = destinationMapKey = destinationDim == null ? null : destinationDim.getSelectedMapKeyUnsynced();
            if (!mapWorld.getMapConnections().isConnected(playerMapKey, destinationMapKey)) {
                TextComponentString messageComponent = new TextComponentString(I18n.format((String)"gui.xaero_wm_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().setColor(TextFormatting.RED));
                Minecraft.getMinecraft().ingameGUI.getChatGUI().printChatMessage((ITextComponent)messageComponent);
                return;
            }
        }
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean partialYTeleportConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.PARTIAL_Y_TELEPORT);
        String string = tpCommand = d == null ? mapWorld.getEffectiveTeleportCommandFormat() : mapWorld.getEffectiveDimensionTeleportCommandFormat();
        String yString = y == -1 ? "~" : (partialYTeleportConfig ? (double)y + 0.5 + "" : y + "");
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z);
        if (d != null) {
            tpCommand = tpCommand.replace("{d}", d + "");
        }
        screen.sendChatMessage(tpCommand, false);
        mapWorld.setCustomDimensionId(null);
        mapWorld.getMapProcessor().checkForWorldUpdate();
    }
}

