/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui.dropdown.rightclick;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.dropdown.rightclick.RightClickOption;

public class GuiRightClickMenu
extends DropDownWidget {
    private IRightClickableElement target;
    private ArrayList<RightClickOption> actionOptions;
    private GuiScreen screen;
    private boolean removed;

    private GuiRightClickMenu(IRightClickableElement target, ArrayList<RightClickOption> options, GuiScreen screen, int x, int y, int w, int titleBackgroundColor, IDropDownContainer container) {
        super(GuiRightClickMenu.convertOptions(options), x - (GuiRightClickMenu.shouldOpenLeft(options.size(), x, w, screen.field_146294_l) ? w : 0), y, w, Integer.valueOf(-1), false, null, container, false);
        this.openingUp = false;
        this.target = target;
        this.screen = screen;
        this.setClosed(false);
        this.actionOptions = options;
        this.selectedBackground = this.selectedHoveredBackground = titleBackgroundColor;
        this.shortenFromTheRight = true;
    }

    private static boolean shouldOpenLeft(int optionCount, int x, int w, int screenWidth) {
        return x + w - screenWidth > 0;
    }

    private static boolean shouldOpenUp(int optionCount, int y, int screenHeight) {
        int potentialHeight = 11 * optionCount;
        return y + potentialHeight - screenHeight > potentialHeight / 2;
    }

    public void setClosed(boolean closed) {
        if (!this.isClosed() && closed) {
            this.removed = true;
        }
        super.setClosed(closed);
    }

    public void selectId(int id, boolean callCallback) {
        if (id == -1) {
            return;
        }
        if (this.removed) {
            return;
        }
        this.actionOptions.get(id).onSelected(this.screen);
        this.setClosed(true);
    }

    public static GuiRightClickMenu getMenu(IRightClickableElement rightClickable, GuiMap screen, int x, int y, int w) {
        return new GuiRightClickMenu(rightClickable, rightClickable.getRightClickOptions(), (GuiScreen)screen, x, y, w, rightClickable.getRightClickTitleBackgroundColor(), (IDropDownContainer)screen);
    }

    public IRightClickableElement getTarget() {
        return this.target;
    }

    private static String[] convertOptions(ArrayList<RightClickOption> options) {
        Supplier<ArrayList<Object>> factory = new Supplier<ArrayList<Object>>(){

            @Override
            public ArrayList<Object> get() {
                return new ArrayList<Object>();
            }
        };
        BiConsumer<ArrayList<Object>, Object> accumulator = new BiConsumer<ArrayList<Object>, Object>(){

            @Override
            public void accept(ArrayList<Object> t, Object u) {
                t.add(u);
            }
        };
        BiConsumer<ArrayList<Object>, ArrayList<Object>> combiner = new BiConsumer<ArrayList<Object>, ArrayList<Object>>(){

            @Override
            public void accept(ArrayList<Object> t, ArrayList<Object> u) {
                t.addAll(u);
            }
        };
        return options.stream().map(new Function<RightClickOption, Object>(){

            @Override
            public Object apply(RightClickOption o) {
                return o.getDisplayName();
            }
        }).collect(factory, accumulator, combiner).toArray(new String[0]);
    }
}

