/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.map.gui.TooltipButton;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<Screen, Screen, Screen> screenFactory;
    private Supplier<Tooltip> tooltipSupplier;
    private boolean active;
    private final boolean consideredAnExit;

    public ScreenSwitchSettingEntry(String name, BiFunction<Screen, Screen, Screen> screenFactoryFromCurrentAndEscape, Tooltip tooltip, boolean active) {
        this(name, screenFactoryFromCurrentAndEscape, tooltip, active, true);
    }

    public ScreenSwitchSettingEntry(String name, BiFunction<Screen, Screen, Screen> screenFactoryFromCurrentAndEscape, Tooltip tooltip, boolean active, boolean consideredAnExit) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = () -> tooltip;
        this.active = active;
        this.consideredAnExit = consideredAnExit;
    }

    public String getStringForSearch() {
        Tooltip entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.get();
        String tooltipFullCode = entryTooltip == null ? null : entryTooltip.getFullCode();
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (tooltipFullCode != null ? " " + tooltipFullCode.replace("gui.xaero", "") : "") + (entryTooltip != null ? " " + entryTooltip.getPlainText() : "");
    }

    public Widget createWidget(int x, int y, int w) {
        TooltipButton button = new TooltipButton(x, y, w, 20, (ITextComponent)new TranslationTextComponent(this.name), b -> {
            Minecraft mc = Minecraft.func_71410_x();
            Screen current = mc.field_71462_r;
            Screen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
            Screen targetScreen = this.screenFactory.apply(current, currentEscScreen);
            if (this.consideredAnExit && current instanceof ScreenBase) {
                ((ScreenBase)current).onExit(targetScreen);
            } else {
                mc.func_147108_a(targetScreen);
            }
        }, this.tooltipSupplier);
        button.field_230693_o_ = this.active;
        return button;
    }

    public BiFunction<Screen, Screen, Screen> getScreenFactory() {
        return this.screenFactory;
    }
}

