/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.server.ServerConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.level.LevelMapPropertiesIO;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayerEntity) {
            PlayerEntity newPlayer = event.getPlayer();
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get((ServerPlayerEntity)oldPlayer));
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            WorldMap.messageHandler.sendToPlayer((ServerPlayerEntity)player, (Object)new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayerEntity player) {
        WorldMap.messageHandler.sendToPlayer(player, (Object)new HandshakePacket());
        ServerConfigManager configManager = WorldMap.INSTANCE.getConfigs().getServerConfigManager();
        ConfigProfile defaultEnforcedProfile = configManager.getDefaultEnforcedProfile();
        boolean caveModeConfig = !Boolean.FALSE.equals(defaultEnforcedProfile.get((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED));
        Set caveModeDimensionsConfig = (Set)defaultEnforcedProfile.get(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        boolean allowOverworldCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(World.OVERWORLD.location()));
        boolean allowNetherCaveModeOnServer = caveModeConfig && (caveModeDimensionsConfig == null || caveModeDimensionsConfig.isEmpty() || caveModeDimensionsConfig.contains(World.NETHER.location()));
        WorldMap.messageHandler.sendToPlayer(player, (Object)new ClientboundRulesPacket(allowOverworldCaveModeOnServer, allowNetherCaveModeOnServer));
        Path propertiesPath = player.level.getServer().getWorldPath(LevelMapPropertiesIO.FILE_NAME);
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.getServer());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            if (properties.isUsable()) {
                WorldMap.messageHandler.sendToPlayer(player, (Object)properties);
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.connection.disconnect((ITextComponent)new TranslationTextComponent("gui.xaero_wm_error_loading_properties"));
        }
    }

    @SubscribeEvent
    public void handlePlayerTickStart(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player instanceof ServerPlayerEntity) {
            WorldMap.serverPlayerTickHandler.tick((ServerPlayerEntity)player);
            return;
        }
    }
}

