/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.ResourceLocation;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.config.util.WorldMapClientConfigUtils;

public class OldFormatSupport {
    private ResourceLocation vanillaStatesResource;
    private boolean vanillaStatesLoaded;
    private HashMap<Integer, HashMap<Integer, BlockState>> vanilla_states;
    private ImmutableMap<String, String> blockRename1314;
    private ImmutableMap<String, Fixer> blockFixes1516;
    private Map<String, String> JIGSAW_ORIENTATION_UPDATES16 = ImmutableMap.builder().put((Object)"", (Object)"north_up").put((Object)"down", (Object)"down_south").put((Object)"up", (Object)"up_north").put((Object)"north", (Object)"north_up").put((Object)"south", (Object)"south_up").put((Object)"west", (Object)"west_up").put((Object)"east", (Object)"east_up").build();
    private Fixer wallFix = nbt -> {
        CompoundNBT properties;
        properties.putString("east", (properties = nbt.getCompound("Properties")).getString("east").equals("true") ? "low" : "none");
        properties.putString("west", properties.getString("west").equals("true") ? "low" : "none");
        properties.putString("north", properties.getString("north").equals("true") ? "low" : "none");
        properties.putString("south", properties.getString("south").equals("true") ? "low" : "none");
    };

    public OldFormatSupport() {
        this.vanillaStatesResource = new ResourceLocation("xaeroworldmap", "vanilla_states.dat");
        this.vanilla_states = new HashMap();
        this.blockRename1314 = ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign");
        this.blockFixes1516 = ImmutableMap.builder().put((Object)"minecraft:jigsaw", nbt -> {
            CompoundNBT properties = nbt.getCompound("Properties");
            String facing = properties.getString("facing");
            properties.remove("facing");
            properties.putString("orientation", this.JIGSAW_ORIENTATION_UPDATES16.get(facing));
        }).put((Object)"minecraft:redstone_wire", nbt -> {
            CompoundNBT properties = nbt.getCompound("Properties");
            String east = properties.getString("east");
            String west = properties.getString("west");
            String north = properties.getString("north");
            String south = properties.getString("south");
            if (east.equals("")) {
                east = "none";
            }
            if (west.equals("")) {
                west = "none";
            }
            if (north.equals("")) {
                north = "none";
            }
            if (south.equals("")) {
                south = "none";
            }
            boolean hasEast = !east.equals("none");
            boolean hasWest = !west.equals("none");
            boolean hasNorth = !north.equals("none");
            boolean hasSouth = !south.equals("none");
            boolean hasHorizontal = hasWest || hasEast;
            boolean hasVertical = hasNorth || hasSouth;
            east = !hasEast && !hasVertical ? "side" : east;
            west = !hasWest && !hasVertical ? "side" : west;
            north = !hasNorth && !hasHorizontal ? "side" : north;
            south = !hasSouth && !hasHorizontal ? "side" : south;
            properties.putString("east", east);
            properties.putString("west", west);
            properties.putString("north", north);
            properties.putString("south", south);
        }).put((Object)"minecraft:andesite_wall", (Object)this.wallFix).put((Object)"minecraft:brick_wall", (Object)this.wallFix).put((Object)"minecraft:cobblestone_wall", (Object)this.wallFix).put((Object)"minecraft:diorite_wall", (Object)this.wallFix).put((Object)"minecraft:end_stone_brick_wall", (Object)this.wallFix).put((Object)"minecraft:granite_wall", (Object)this.wallFix).put((Object)"minecraft:mossy_cobblestone_wall", (Object)this.wallFix).put((Object)"minecraft:mossy_stone_brick_wall", (Object)this.wallFix).put((Object)"minecraft:nether_brick_wall", (Object)this.wallFix).put((Object)"minecraft:prismarine_wall", (Object)this.wallFix).put((Object)"minecraft:red_nether_brick_wall", (Object)this.wallFix).put((Object)"minecraft:red_sandstone_wall", (Object)this.wallFix).put((Object)"minecraft:sandstone_wall", (Object)this.wallFix).put((Object)"minecraft:stone_brick_wall", (Object)this.wallFix).build();
    }

    public void loadVanillaStates() throws IOException, CommandSyntaxException {
        if (WorldMapClientConfigUtils.getDebug()) {
            WorldMap.LOGGER.info("Loading vanilla states...");
        }
        this.loadStates(this.vanilla_states, Minecraft.getInstance().getResourceManager().getResource(this.vanillaStatesResource).getInputStream());
        this.vanillaStatesLoaded = true;
    }

    public void loadModdedStates(MapProcessor mapProcessor, String worldId, String dimId, String mwId) throws FileNotFoundException, IOException, CommandSyntaxException {
        if (worldId == null) {
            return;
        }
        if (WorldMapClientConfigUtils.getDebug()) {
            WorldMap.LOGGER.info("Loading modded states for the world...");
        }
        Path mainFolder = mapProcessor.getMapSaveLoad().getMainFolder(worldId, dimId);
        Path subFolder = mapProcessor.getMapSaveLoad().getMWSubFolder(worldId, mainFolder, mwId);
        Path inputPath = subFolder.resolve("states.dat");
        if (!Files.exists(subFolder, new LinkOption[0])) {
            Files.createDirectories(subFolder, new FileAttribute[0]);
        }
    }

    private void loadStates(HashMap<Integer, HashMap<Integer, BlockState>> stateMap, InputStream inputStream) throws IOException, CommandSyntaxException {
        DataInputStream input = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            while (true) {
                int stateId = input.readInt();
                int blockId = stateId & 0xFFF;
                int meta = stateId >> 12 & 0xFFFFF;
                CompoundNBT nbtCompound = CompressedStreamTools.read((DataInput)input);
                this.fixBlock(nbtCompound, 1);
                BlockState blockState = WorldMap.unknownBlockStateCache.getBlockStateFromNBT(nbtCompound);
                this.putState(stateMap, blockId, meta, blockState);
            }
        }
        catch (EOFException eOFException) {
            if (WorldMapClientConfigUtils.getDebug()) {
                WorldMap.LOGGER.info("Done.");
            }
            input.close();
            return;
        }
    }

    public void loadStates() throws IOException, CommandSyntaxException {
        if (!this.vanillaStatesLoaded) {
            this.loadVanillaStates();
        }
    }

    private void putState(HashMap<Integer, HashMap<Integer, BlockState>> stateMap, int blockId, int meta, BlockState blockState) {
        HashMap<Integer, Object> blockStates = stateMap.get(blockId);
        if (blockStates == null) {
            blockStates = new HashMap();
            stateMap.put(blockId, blockStates);
        }
        blockStates.put(meta, blockState);
    }

    private BlockState getStateForId(int stateId, HashMap<Integer, HashMap<Integer, BlockState>> stateMap) {
        int blockId = stateId & 0xFFF;
        HashMap<Integer, BlockState> blockStates = stateMap.get(blockId);
        if (blockStates == null) {
            return null;
        }
        int meta = stateId >> 12 & 0xFFFFF;
        return blockStates.getOrDefault(meta, null);
    }

    public BlockState getStateForId(int stateId) {
        BlockState vanillaState = this.getStateForId(stateId, this.vanilla_states);
        if (vanillaState != null) {
            return vanillaState;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void fixBlock(CompoundNBT nbt, int version) {
        if (version == 1) {
            this.fixBlockName1314(nbt);
        }
        if (version < 3) {
            this.fixBlock1516(nbt);
        }
    }

    private void fixBlockName1314(CompoundNBT nbt) {
        String name = nbt.getString("Name");
        nbt.putString("Name", (String)this.blockRename1314.getOrDefault((Object)name, (Object)name));
    }

    private void fixBlock1516(CompoundNBT nbt) {
        String name = nbt.getString("Name");
        Fixer fixer = (Fixer)this.blockFixes1516.get((Object)name);
        if (fixer != null) {
            fixer.fix(nbt);
        }
    }

    public static interface Fixer {
        public void fix(CompoundNBT var1);
    }
}

