/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import com.mojang.datafixers.DataFixer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.StateHolder;
import net.minecraft.util.BitArray;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.executor.Executor;
import xaero.map.file.worldsave.WorldDataChunkTileEntityLookup;
import xaero.map.file.worldsave.biome.WorldDataBiomeManager;
import xaero.map.misc.CachedFunction;
import xaero.map.mods.SupportMods;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private MapProcessor mapProcessor;
    private boolean[] shouldEnterGround;
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private byte[] skyLightLevels;
    private int[] topH;
    private MapBlock buildingObject = new MapBlock();
    private OverlayBuilder[] overlayBuilders;
    private BlockPos.Mutable mutableBlockPos;
    private IPalette<BlockState> blockStatePalette;
    private BitArray heightMapBitArray;
    private BitArray blockStatesBitArray;
    private int currentBits;
    private CompoundNBT[] chunkNBTCompounds;
    public Object taskCreationSync;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache;
    private int[] firstTransparentStateY;
    private boolean[] shouldExtendTillTheBottom;
    private CachedFunction<FluidState, BlockState> fluidToBlock;
    private WorldDataBiomeManager biomeManager;

    public WorldDataReader(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, WorldDataBiomeManager biomeManager) {
        this.underair = new boolean[256];
        this.shouldEnterGround = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.skyLightLevels = new byte[256];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new BlockPos.Mutable();
        this.blockStatePalette = new HashMapPalette(Block.BLOCK_STATE_REGISTRY, 32, null, NBTUtil::readBlockState, NBTUtil::writeBlockState);
        this.heightMapBitArray = new BitArray(9, 256);
        this.taskCreationSync = new Object();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
        this.chunkNBTCompounds = new CompoundNBT[16];
        this.topH = new int[256];
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<StateHolder, Boolean>(state -> this.mapProcessor.getMapWriter().shouldOverlay((StateHolder<?, ?>)state));
        this.shouldExtendTillTheBottom = new boolean[256];
        this.firstTransparentStateY = new int[256];
        this.fluidToBlock = new CachedFunction<FluidState, BlockState>(FluidState::createLegacyBlock);
        this.biomeManager = biomeManager;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, ServerWorld serverWorld, boolean loading, int[] chunkCountDest, Executor renderExecutor) {
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = this.mapProcessor.getLeafMapRegion(region.getCaveLayer(), prevRegX, prevRegZ, false);
        region.updateCaveMode();
        int caveStart = region.getCaveStart();
        int caveDepth = region.getCaveDepth();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean worldHasSkylight = serverWorld.dimensionType().hasSkyLight();
        boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
        boolean flowers = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS);
        if (loading || region.getLoadState() == 2) {
            serverWorld.getServer().submit(() -> serverWorld.getChunkSource().save(false)).join();
            ChunkManager chunkManager = serverWorld.getChunkSource().chunkMap;
            MutableRegistry<Biome> biomeRegistry = region.getBiomeRegistry();
            this.biomeManager.resetChunkBiomeData(region.getRegionX(), region.getRegionZ(), BiomeRegistry.THE_VOID, biomeRegistry);
            IBiomeMagnifier biomeZoomer = serverWorld.dimensionType().getBiomeZoomer();
            CompletableFuture lastFuture = null;
            for (int i = -1; i < 9; ++i) {
                for (int j = -1; j < 9; ++j) {
                    if (i < 0 || j < 0 || i >= 8 || j >= 8) {
                        this.handleTileChunkOutsideRegion(i, j, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j, caveStart, ignoreHeightmaps, biomeRegistry, flowers, (ChunkLoader)chunkManager);
                    } else {
                        MapTileChunk tileChunk = region.getChunk(i, j);
                        if (tileChunk == null) {
                            tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                            region.setChunk(i, j, tileChunk);
                            MapRegion mapRegion = region;
                            synchronized (mapRegion) {
                                region.setAllCachePrepared(false);
                            }
                        }
                        if (region.isMetaLoaded()) {
                            tileChunk.getLeafTexture().setBufferedTextureVersion(region.getAndResetCachedTextureVersion(i, j));
                        }
                        this.readChunkNBTCompounds((ChunkLoader)chunkManager, tileChunk);
                        this.buildTileChunk(tileChunk, caveStart, caveDepth, worldHasSkylight, ignoreHeightmaps, prevRegion, serverWorld, biomeRegistry, flowers);
                        if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                            region.uncountTextureBiomes(tileChunk.getLeafTexture());
                            region.setChunk(i, j, null);
                            tileChunk.getLeafTexture().deleteTexturesAndBuffers();
                            tileChunk = null;
                        } else {
                            if (!loading && !tileChunk.includeInSave() && tileChunk.hasHadTerrain()) {
                                tileChunk.getLeafTexture().deleteColorBuffer();
                                tileChunk.unsetHasHadTerrain();
                                tileChunk.setChanged(false);
                            }
                            if (chunkCountDest != null) {
                                chunkCountDest[0] = chunkCountDest[0] + 1;
                            }
                        }
                    }
                    if (i <= 0 || j <= 0) continue;
                    MapTileChunk topLeftTileChunk = region.getChunk(i - 1, j - 1);
                    if (topLeftTileChunk != null && topLeftTileChunk.includeInSave()) {
                        this.fillBiomes(topLeftTileChunk, biomeZoomer, biomeRegistry);
                        lastFuture = renderExecutor.submit(() -> {
                            this.transferFilledBiomes(topLeftTileChunk, biomeZoomer, (Registry<Biome>)biomeRegistry);
                            topLeftTileChunk.setToUpdateBuffers(true);
                            topLeftTileChunk.setChanged(false);
                            topLeftTileChunk.setLoadState((byte)2);
                        });
                    }
                    if (lastFuture == null || i != 8 || j != 8) continue;
                    lastFuture.join();
                }
            }
            this.biomeManager.clear();
            if (region.isNormalMapData()) {
                region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    private void readChunkNBTCompounds(ChunkLoader chunkLoader, MapTileChunk tileChunk) {
        for (int xl = 0; xl < 4; ++xl) {
            for (int zl = 0; zl < 4; ++zl) {
                int i = zl << 2 | xl;
                try {
                    this.chunkNBTCompounds[i] = chunkLoader.read(new ChunkPos(tileChunk.getX() * 4 + xl, tileChunk.getZ() * 4 + zl));
                    continue;
                }
                catch (IOException e) {
                    this.chunkNBTCompounds[i] = null;
                }
            }
        }
    }

    public CompoundNBT readChunk(RegionFile regionFile, ChunkPos pos) throws IOException {
        try (DataInputStream datainputstream = regionFile.getChunkDataInputStream(pos);){
            if (datainputstream != null) {
                CompoundNBT compoundNBT = CompressedStreamTools.read((DataInput)datainputstream);
                return compoundNBT;
            }
            CompoundNBT compoundNBT = null;
            return compoundNBT;
        }
    }

    private void buildTileChunk(MapTileChunk tileChunk, int caveStart, int caveDepth, boolean worldHasSkylight, boolean ignoreHeightmaps, MapRegion prevRegion, ServerWorld serverWorld, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        tileChunk.unincludeInSave();
        tileChunk.resetHeights();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                int i;
                DataFixer fixer;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                int chunkZ = (tileChunk.getZ() << 2) + insideZ;
                CompoundNBT nbttagcompound = this.chunkNBTCompounds[insideZ << 2 | insideX];
                if (nbttagcompound == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                    this.mapProcessor.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                if (this.buildTile(nbttagcompound = NBTUtil.update((DataFixer)(fixer = Minecraft.getInstance().getFixerUpper()), (DefaultTypeReferences)DefaultTypeReferences.CHUNK, (CompoundNBT)nbttagcompound, (int)(i = nbttagcompound.contains("DataVersion", 99) ? nbttagcompound.getInt("DataVersion") : -1)), tile, tileChunk, chunkX, chunkZ, chunkX & 0x1F, chunkZ & 0x1F, caveStart, caveDepth, worldHasSkylight, ignoreHeightmaps, serverWorld, biomeRegistry, flowers)) {
                    tile.setWrittenCave(caveStart, caveDepth);
                    tileChunk.setTile(insideX, insideZ, tile, this.blockStateShortShapeCache);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                this.mapProcessor.getTilePool().addToPool(tile);
            }
        }
    }

    private boolean buildTile(CompoundNBT nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int insideRegionX, int insideRegionZ, int caveStart, int caveDepth, boolean worldHasSkylight, boolean ignoreHeightmaps, ServerWorld serverWorld, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        boolean heightMapExists;
        CompoundNBT levelCompound = nbttagcompound.getCompound("Level");
        String status = levelCompound.getString("Status");
        int chunkStatusIndex = ChunkStatus.byName((String)status).getIndex();
        if (chunkStatusIndex < ChunkStatus.BIOMES.getIndex()) {
            return false;
        }
        int[] biomes = null;
        if (levelCompound.contains("Biomes", 11) && (biomes = levelCompound.getIntArray("Biomes")).length != 1024) {
            biomes = null;
        }
        this.biomeManager.setBiomeForRegionChunk(insideRegionX, insideRegionZ, biomes);
        if (chunkStatusIndex < ChunkStatus.FEATURES.getIndex()) {
            return false;
        }
        ListNBT sectionsList = levelCompound.getList("Sections", 10);
        int fillCounter = 256;
        int[] topH = this.topH;
        boolean[] shouldExtendTillTheBottom = this.shouldExtendTillTheBottom;
        boolean cave = caveStart != Integer.MAX_VALUE;
        boolean fullCave = caveStart == Integer.MIN_VALUE;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.blockFound[i] = false;
            this.underair[i] = this.shouldEnterGround[i] = fullCave;
            this.lightLevels[i] = 0;
            this.skyLightLevels[i] = worldHasSkylight ? 15 : 0;
            topH[i] = 0;
            shouldExtendTillTheBottom[i] = false;
        }
        boolean oldHeightMap = !levelCompound.contains("Heightmaps", 10);
        int[] oldHeightMapArray = null;
        if (oldHeightMap) {
            oldHeightMapArray = levelCompound.getIntArray("HeightMap");
            heightMapExists = oldHeightMapArray.length == 256;
        } else {
            long[] heightMapArray = levelCompound.getCompound("Heightmaps").getLongArray("WORLD_SURFACE");
            boolean bl = heightMapExists = heightMapArray.length == 37;
            if (heightMapExists) {
                System.arraycopy(heightMapArray, 0, this.heightMapBitArray.getRaw(), 0, heightMapArray.length);
            }
        }
        boolean lightIsOn = !levelCompound.contains("isLightOn", 1) || levelCompound.getBoolean("isLightOn");
        int caveStartSectionHeight = (fullCave ? serverWorld.getMaxBuildHeight() - 1 : caveStart) >> 4 << 4;
        int lowH = 0;
        if (cave && !fullCave && (lowH = caveStart + 1 - caveDepth) < 0) {
            lowH = 0;
        }
        int lowHSection = lowH >> 4 << 4;
        boolean transparency = true;
        if (sectionsList.size() == 0) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    MapBlock currentPixel = tile.getBlock(i, j);
                    this.buildingObject.prepareForWriting();
                    this.buildingObject.write(Blocks.AIR.defaultBlockState(), 0, 0, null, (byte)0, false, cave);
                    tile.setBlock(i, j, this.buildingObject);
                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                }
            }
        } else {
            ListNBT tileEntitiesNbt = levelCompound.getList("TileEntities", 10);
            WorldDataChunkTileEntityLookup tileEntityLookup = null;
            if (!tileEntitiesNbt.isEmpty()) {
                tileEntityLookup = new WorldDataChunkTileEntityLookup(tileEntitiesNbt);
            }
            int prevSectionHeight = Integer.MAX_VALUE;
            int sectionHeight = Integer.MAX_VALUE;
            for (int i = sectionsList.size() - 1; i >= 0 && fillCounter > 0; --i) {
                boolean hasBlocks;
                CompoundNBT sectionCompound = sectionsList.getCompound(i);
                sectionHeight = sectionCompound.getByte("Y") * 16;
                boolean bl = hasBlocks = sectionCompound.contains("BlockStates", 12) && sectionHeight >= lowHSection;
                if (i > 0 && !hasBlocks && !sectionCompound.contains("BlockLight", 7) && (!cave || !sectionCompound.contains("SkyLight", 7))) continue;
                boolean previousSectionExists = prevSectionHeight - sectionHeight == 16;
                boolean underAirByDefault = cave && !previousSectionExists && caveStartSectionHeight > sectionHeight;
                int sectionBasedHeight = sectionHeight + 15;
                boolean preparedSectionData = false;
                byte[] lightMap = null;
                byte[] skyLightMap = null;
                prevSectionHeight = sectionHeight;
                for (int z = 0; z < 16; ++z) {
                    block9: for (int x = 0; x < 16; ++x) {
                        int heightMapValue;
                        int pos_2d = (z << 4) + x;
                        if (this.blockFound[pos_2d]) continue;
                        int n = heightMapExists ? (oldHeightMap ? oldHeightMapArray[pos_2d] : this.heightMapBitArray.get(pos_2d)) : (heightMapValue = 255);
                        int startHeight = cave && !fullCave ? caveStart : (ignoreHeightmaps || heightMapValue == -1 ? sectionBasedHeight : heightMapValue + 3);
                        if (i > 0 && ++startHeight < sectionHeight) continue;
                        int localStartHeight = 15;
                        if (startHeight >> 4 << 4 == sectionHeight) {
                            localStartHeight = startHeight & 0xF;
                        }
                        if (!preparedSectionData) {
                            if (hasBlocks) {
                                ListNBT paletteList = sectionCompound.getList("Palette", 10);
                                long[] blockStatesArray = sectionCompound.getLongArray("BlockStates");
                                int bits = blockStatesArray.length * 64 / 4096;
                                int bitsOther = Math.max(4, MathHelper.ceillog2((int)paletteList.size()));
                                if (bitsOther > 8) {
                                    bits = bitsOther;
                                }
                                if (this.blockStatesBitArray == null || this.currentBits != bits) {
                                    this.blockStatesBitArray = new BitArray(bits, 4096);
                                    this.currentBits = bits;
                                }
                                if (blockStatesArray.length == this.blockStatesBitArray.getRaw().length) {
                                    System.arraycopy(blockStatesArray, 0, this.blockStatesBitArray.getRaw(), 0, blockStatesArray.length);
                                    this.blockStatePalette.read(paletteList);
                                } else {
                                    hasBlocks = false;
                                }
                            }
                            if (lightIsOn) {
                                if (sectionCompound.contains("BlockLight", 7) && (lightMap = sectionCompound.getByteArray("BlockLight")).length != 2048) {
                                    lightMap = null;
                                }
                                if (cave && sectionCompound.contains("SkyLight", 7) && (skyLightMap = sectionCompound.getByteArray("SkyLight")).length != 2048) {
                                    skyLightMap = null;
                                }
                            }
                            preparedSectionData = true;
                        }
                        if (underAirByDefault) {
                            this.underair[pos_2d] = true;
                        }
                        for (int y = localStartHeight; y >= 0; --y) {
                            byte dataLight;
                            boolean buildResult;
                            CompoundNBT tileEntityNbt;
                            BlockState state;
                            int h = sectionHeight + y;
                            int pos = y << 8 | pos_2d;
                            BlockState blockState = state = hasBlocks ? (BlockState)this.blockStatePalette.valueFor(this.blockStatesBitArray.get(pos)) : Blocks.AIR.defaultBlockState();
                            if (state != null && tileEntityLookup != null && !(state.getBlock() instanceof AirBlock) && SupportMods.framedBlocks() && SupportMods.supportFramedBlocks.isFrameBlock(null, state) && (tileEntityNbt = tileEntityLookup.getTileEntityNbt(x, h, z)) != null) {
                                if (tileEntityNbt.contains("camo_state", 10)) {
                                    try {
                                        state = NBTUtil.readBlockState((CompoundNBT)tileEntityNbt.getCompound("camo_state"));
                                    }
                                    catch (IllegalArgumentException iae) {
                                        state = null;
                                    }
                                } else if (tileEntityNbt.contains("camo", 10)) {
                                    CompoundNBT fluidTag;
                                    CompoundNBT camoNbt = tileEntityNbt.getCompound("camo");
                                    if (camoNbt.contains("state", 10)) {
                                        try {
                                            state = NBTUtil.readBlockState((CompoundNBT)camoNbt.getCompound("state"));
                                        }
                                        catch (IllegalArgumentException iae) {
                                            state = null;
                                        }
                                    } else if (camoNbt.contains("fluid", 10) && (fluidTag = camoNbt.getCompound("fluid")).contains("Name", 8)) {
                                        String fluidId = fluidTag.getString("Name");
                                        Fluid fluid = (Fluid)Registry.FLUID.get(new ResourceLocation(fluidId));
                                        BlockState blockState2 = state = fluid == null ? null : this.fluidToBlock.apply(fluid.defaultFluidState());
                                    }
                                }
                            }
                            if (state == null) {
                                state = Blocks.AIR.defaultBlockState();
                            }
                            this.mutableBlockPos.set(chunkX << 4 | x, sectionHeight | y, chunkZ << 4 | z);
                            OverlayBuilder overlayBuilder = this.overlayBuilders[pos_2d];
                            if (!shouldExtendTillTheBottom[pos_2d] && !overlayBuilder.isEmpty() && this.firstTransparentStateY[pos_2d] - h >= 5) {
                                shouldExtendTillTheBottom[pos_2d] = true;
                            }
                            boolean bl2 = buildResult = h >= lowH && h < startHeight && this.buildPixel(this.buildingObject, state, x, h, z, pos_2d, this.lightLevels[pos_2d], this.skyLightLevels[pos_2d], null, cave, fullCave, overlayBuilder, serverWorld, this.mutableBlockPos, biomeRegistry, topH, shouldExtendTillTheBottom[pos_2d], flowers, transparency);
                            if (!buildResult && (y == 0 && i == 0 || h <= lowH)) {
                                this.lightLevels[pos_2d] = 0;
                                if (cave) {
                                    this.skyLightLevels[pos_2d] = 0;
                                }
                                h = 0;
                                state = Blocks.AIR.defaultBlockState();
                                buildResult = true;
                            }
                            if (buildResult) {
                                byte skyLight;
                                this.buildingObject.prepareForWriting();
                                overlayBuilder.finishBuilding(this.buildingObject);
                                boolean glowing = this.mapProcessor.getMapWriter().isGlowing(state);
                                byte light = this.lightLevels[pos_2d];
                                if (cave && light < 15 && this.buildingObject.getNumberOfOverlays() == 0 && (skyLight = this.skyLightLevels[pos_2d]) > light) {
                                    light = skyLight;
                                }
                                this.buildingObject.write(state, h, topH[pos_2d], null, light, glowing, cave);
                                MapBlock currentPixel = tile.getBlock(x, z);
                                boolean equalsSlopesExcluded = this.buildingObject.equalsSlopesExcluded(currentPixel);
                                boolean fullyEqual = this.buildingObject.equals(currentPixel, equalsSlopesExcluded);
                                if (!fullyEqual) {
                                    tile.setBlock(x, z, this.buildingObject);
                                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                    if (!equalsSlopesExcluded) {
                                        tileChunk.setChanged(true);
                                    }
                                }
                                this.blockFound[pos_2d] = true;
                                --fillCounter;
                                continue block9;
                            }
                            byte by = dataLight = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                            if (cave && dataLight < 15 && worldHasSkylight) {
                                int dataSkyLight = !ignoreHeightmaps && !fullCave && startHeight > heightMapValue ? 15 : (skyLightMap == null ? 0 : this.nibbleValue(skyLightMap, pos));
                                this.skyLightLevels[pos_2d] = dataSkyLight;
                            }
                            this.lightLevels[pos_2d] = dataLight;
                        }
                    }
                }
            }
        }
        tile.setWorldInterpretationVersion(1);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, BlockState state, int x, int h, int z, int pos_2d, byte light, byte skyLight, RegistryKey<Biome> biome, boolean cave, boolean fullCave, OverlayBuilder overlayBuilder, ServerWorld serverWorld, BlockPos.Mutable mutableBlockPos, MutableRegistry<Biome> biomeRegistry, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers, boolean transparency) {
        FluidState fluidFluidState = state.getFluidState();
        Block b = state.getBlock();
        if (!(fluidFluidState.isEmpty() || cave && this.shouldEnterGround[pos_2d])) {
            this.underair[pos_2d] = true;
            BlockState fluidState = this.fluidToBlock.apply(fluidFluidState);
            if (this.buildPixelHelp(pixel, fluidState, fluidState.getBlock(), fluidFluidState, pos_2d, h, cave, light, skyLight, biome, overlayBuilder, serverWorld, biomeRegistry, topH, shouldExtendTillTheBottom, flowers, transparency)) {
                return true;
            }
        }
        if (b instanceof AirBlock) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d] && cave) {
            return false;
        }
        if (b == this.fluidToBlock.apply(fluidFluidState).getBlock()) {
            return false;
        }
        if (cave && this.shouldEnterGround[pos_2d]) {
            if (!(state.getMaterial().isFlammable() || state.getMaterial().isReplaceable() || state.getMaterial().getPushReaction() == PushReaction.DESTROY || this.shouldOverlayCached((StateHolder<?, ?>)state))) {
                this.underair[pos_2d] = false;
                this.shouldEnterGround[pos_2d] = false;
            }
            return false;
        }
        return this.buildPixelHelp(pixel, state, state.getBlock(), null, pos_2d, h, cave, light, skyLight, biome, overlayBuilder, serverWorld, biomeRegistry, topH, shouldExtendTillTheBottom, flowers, transparency);
    }

    private boolean buildPixelHelp(MapBlock pixel, BlockState state, Block b, FluidState fluidFluidState, int pos_2d, int h, boolean cave, byte light, byte skyLight, RegistryKey<Biome> dataBiome, OverlayBuilder overlayBuilder, ServerWorld serverWorld, MutableRegistry<Biome> biomeRegistry, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers, boolean transparency) {
        if (this.mapProcessor.getMapWriter().isInvisible(state, b, flowers)) {
            return false;
        }
        if (this.shouldOverlayCached((StateHolder<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (cave && !this.underair[pos_2d]) {
                return !transparency;
            }
            if (h > topH[pos_2d]) {
                topH[pos_2d] = h;
            }
            byte overlayLight = light;
            if (overlayBuilder.isEmpty()) {
                this.firstTransparentStateY[pos_2d] = h;
                if (cave && skyLight > overlayLight) {
                    overlayLight = skyLight;
                }
            }
            if (shouldExtendTillTheBottom) {
                overlayBuilder.getCurrentOverlay().increaseOpacity(overlayBuilder.getCurrentOverlay().getState().getLightBlock((IBlockReader)serverWorld, (BlockPos)this.mutableBlockPos));
            } else {
                overlayBuilder.build(state, state.getLightBlock((IBlockReader)serverWorld, (BlockPos)this.mutableBlockPos), overlayLight, this.mapProcessor, dataBiome);
            }
            return !transparency;
        }
        if (!this.mapProcessor.getMapWriter().hasVanillaColor(state, (World)serverWorld, (BlockPos)this.mutableBlockPos)) {
            return false;
        }
        if (cave && !this.underair[pos_2d]) {
            return true;
        }
        if (h > topH[pos_2d]) {
            topH[pos_2d] = h;
        }
        return true;
    }

    private void handleTileChunkOutsideRegion(int relativeX, int relativeZ, int actualX, int actualZ, int caveStart, boolean ignoreHeightmaps, MutableRegistry<Biome> biomeRegistry, boolean flowers, ChunkLoader chunkLoader) {
        int insideZ;
        int insideX;
        int minInsideX = relativeX < 0 ? 3 : 0;
        int maxInsideX = relativeX > 7 ? 0 : 3;
        int minInsideZ = relativeZ < 0 ? 3 : 0;
        int maxInsideZ = relativeZ > 7 ? 0 : 3;
        for (insideX = minInsideX; insideX <= maxInsideX; ++insideX) {
            for (insideZ = minInsideZ; insideZ <= maxInsideZ; ++insideZ) {
                try {
                    this.chunkNBTCompounds[insideZ << 2 | insideX] = chunkLoader.read(new ChunkPos(actualX << 2 | insideX, actualZ << 2 | insideZ));
                    continue;
                }
                catch (IOException e) {
                    this.chunkNBTCompounds[insideZ << 2 | insideX] = null;
                }
            }
        }
        for (insideX = minInsideX; insideX <= maxInsideX; ++insideX) {
            for (insideZ = minInsideZ; insideZ <= maxInsideZ; ++insideZ) {
                CompoundNBT nbt = this.chunkNBTCompounds[insideZ << 2 | insideX];
                int insideRegionX = relativeX << 2 | insideX;
                int insideRegionZ = relativeZ << 2 | insideZ;
                if (nbt == null) continue;
                DataFixer fixer = Minecraft.getInstance().getFixerUpper();
                int i = nbt.contains("DataVersion", 99) ? nbt.getInt("DataVersion") : -1;
                nbt = NBTUtil.update((DataFixer)fixer, (DefaultTypeReferences)DefaultTypeReferences.CHUNK, (CompoundNBT)nbt, (int)i);
                this.handleTileOutsideRegion(nbt, insideRegionX, insideRegionZ);
            }
        }
    }

    private void handleTileOutsideRegion(CompoundNBT nbt, int insideRegionX, int insideRegionZ) {
        CompoundNBT levelCompound = nbt.getCompound("Level");
        String status = levelCompound.getString("Status");
        if (ChunkStatus.byName((String)status).getIndex() < ChunkStatus.BIOMES.getIndex()) {
            return;
        }
        int[] biomes = null;
        if (levelCompound.contains("Biomes", 11) && (biomes = levelCompound.getIntArray("Biomes")).length != 1024) {
            biomes = null;
        }
        this.biomeManager.setBiomeForRegionChunk(insideRegionX, insideRegionZ, biomes);
    }

    private void fillBiomes(MapTileChunk tileChunk, IBiomeMagnifier biomeZoomer, MutableRegistry<Biome> biomeRegistry) {
        try {
            for (int insideX = 0; insideX < 4; ++insideX) {
                for (int insideZ = 0; insideZ < 4; ++insideZ) {
                    MapTile mapTile = tileChunk.getTile(insideX, insideZ);
                    if (mapTile == null) continue;
                    mapTile.setLoaded(true);
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            Biome biome;
                            RegistryKey biomeKey;
                            MapBlock mapBlock = mapTile.getBlock(x, z);
                            int topHeight = mapBlock.getTopHeight();
                            if (topHeight == -1) {
                                topHeight = mapBlock.getHeight();
                            }
                            if ((biomeKey = (RegistryKey)biomeRegistry.getResourceKey((Object)(biome = this.biomeManager.getBiome(biomeZoomer, mapTile.getChunkX() << 4 | x, topHeight, mapTile.getChunkZ() << 4 | z))).orElse(null)) == null) {
                                ResourceLocation forgeRegistriesKey = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
                                RegistryKey registryKey = biomeKey = forgeRegistriesKey == null ? null : RegistryKey.create((RegistryKey)Registry.BIOME_REGISTRY, (ResourceLocation)forgeRegistriesKey);
                            }
                            if (biomeKey == null) continue;
                            mapBlock.setBiome((RegistryKey<Biome>)biomeKey);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("Error filling tile chunk with zoomed biomes", t);
        }
    }

    private void transferFilledBiomes(MapTileChunk tileChunk, IBiomeMagnifier biomeZoomer, Registry<Biome> biomeRegistry) {
        try {
            for (int insideX = 0; insideX < 4; ++insideX) {
                for (int insideZ = 0; insideZ < 4; ++insideZ) {
                    MapTile mapTile = tileChunk.getTile(insideX, insideZ);
                    if (mapTile == null || !mapTile.isLoaded()) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            MapBlock mapBlock = mapTile.getBlock(x, z);
                            tileChunk.getLeafTexture().setBiome(insideX << 4 | x, insideZ << 4 | z, mapBlock.getBiome());
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("Error transferring filled tile chunk with zoomed biomes", t);
        }
    }

    private boolean shouldOverlayCached(StateHolder<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }
}

