/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave.biome;

import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.IBiomeMagnifier;
import xaero.map.file.worldsave.biome.WorldDataReaderChunkBiomeData;

public class WorldDataBiomeManager
implements BiomeManager.IBiomeReader {
    private final long biomeZoomSeed;
    private final WorldDataReaderChunkBiomeData[] chunkBiomeData;
    private int regionX;
    private int regionZ;
    private Biome defaultBiome;
    private MutableRegistry<Biome> biomeRegistry;

    public WorldDataBiomeManager(long biomeZoomSeed) {
        this.biomeZoomSeed = biomeZoomSeed;
        this.chunkBiomeData = new WorldDataReaderChunkBiomeData[1156];
        for (int i = 0; i < this.chunkBiomeData.length; ++i) {
            this.chunkBiomeData[i] = new WorldDataReaderChunkBiomeData();
        }
    }

    public void resetChunkBiomeData(int regionX, int regionZ, Biome defaultBiome, MutableRegistry<Biome> biomeRegistry) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.biomeRegistry = biomeRegistry;
    }

    public void clear() {
        for (int i = 0; i < this.chunkBiomeData.length; ++i) {
            this.chunkBiomeData[i].clear();
        }
    }

    private WorldDataReaderChunkBiomeData getChunkBiomeData(int chunkX, int chunkZ) {
        if (chunkX < -1 || chunkZ < -1 || chunkX > 32 || chunkZ > 32) {
            return null;
        }
        return this.chunkBiomeData[(chunkZ + 1) * 34 + chunkX + 1];
    }

    public void setBiomeForRegionChunk(int chunkX, int chunkZ, int[] biomes) {
        this.getChunkBiomeData(chunkX, chunkZ).setBiomes(biomes);
    }

    public Biome getBiome(IBiomeMagnifier biomeZoomer, int x, int y, int z) {
        this.defaultBiome = null;
        this.defaultBiome = this.getNoiseBiome(x >> 2, y >> 2, z >> 2);
        if (this.defaultBiome == null) {
            this.defaultBiome = BiomeRegistry.THE_VOID;
        }
        return biomeZoomer.getBiome(this.biomeZoomSeed, x, y, z, (BiomeManager.IBiomeReader)this);
    }

    public Biome getNoiseBiome(int x, int y, int z) {
        int relativeX = x - this.regionX * 128;
        int relativeZ = z - this.regionZ * 128;
        int chunkX = relativeX >> 2;
        int chunkZ = relativeZ >> 2;
        int quadX = relativeX & 3;
        int quadZ = relativeZ & 3;
        WorldDataReaderChunkBiomeData chunkBiomeData = this.getChunkBiomeData(chunkX, chunkZ);
        if (chunkBiomeData == null) {
            return this.defaultBiome;
        }
        Biome biome = chunkBiomeData.getNoiseBiome(quadX, y, quadZ, this.biomeRegistry);
        if (biome == null) {
            return this.defaultBiome;
        }
        return biome;
    }
}

