/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ImprovedFramebuffer
extends Framebuffer {
    private static Field MAIN_RENDER_TARGET_FIELD = ReflectionUtils.getFieldReflection(Minecraft.class, (String)"mainRenderTarget", (String)"", (String)"", (String)"field_147124_at");
    private static Framebuffer mainRenderTargetBackup;
    private int type;
    public int framebufferTexture;
    private int depthBuffer;
    private boolean superConstructorWorks;
    private static final int GL_FB_INCOMPLETE_ATTACHMENT = 36054;
    private static final int GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
    private static final int GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
    private static final int GL_FB_INCOMPLETE_READ_BUFFER = 36060;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(width, height, useDepthIn, Minecraft.ON_OSX);
        if (!this.superConstructorWorks) {
            this.resize(width, height, Minecraft.ON_OSX);
        }
    }

    public void resize(int width, int height, boolean isMac) {
        this.superConstructorWorks = true;
        GlStateManager._enableDepthTest();
        if (this.frameBufferId >= 0) {
            this.destroyBuffers();
        }
        this.createBuffers(width, height, isMac);
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, 0);
    }

    public void createBuffers(int width, int height, boolean isMac) {
        this.viewWidth = width;
        this.viewHeight = height;
        this.width = width;
        this.height = height;
        this.frameBufferId = this.genFrameBuffers();
        if (this.frameBufferId == -1) {
            this.clear(isMac);
            return;
        }
        this.framebufferTexture = TextureUtil.generateTextureId();
        if (this.framebufferTexture == -1) {
            this.clear(isMac);
            return;
        }
        if (this.useDepth) {
            this.depthBuffer = this.genRenderbuffers();
            if (this.depthBuffer == -1) {
                this.clear(isMac);
                return;
            }
        }
        this.setFilterMode(9728);
        GlStateManager._bindTexture((int)this.framebufferTexture);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, this.frameBufferId);
        ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.framebufferTexture, 0);
        if (this.useDepth) {
            ImprovedFramebuffer.bindRenderbuffer(this.type, 36161, this.depthBuffer);
            ImprovedFramebuffer.renderbufferStorage(this.type, 36161, 33190, this.width, this.height);
            ImprovedFramebuffer.framebufferRenderbuffer(this.type, 36160, 36096, 36161, this.depthBuffer);
        }
        this.checkStatus();
        this.clear(isMac);
        this.unbindRead();
    }

    private int genFrameBuffers() {
        int fbo = -1;
        this.type = -1;
        if (GL.getCapabilities().OpenGL30) {
            fbo = GL30.glGenFramebuffers();
            this.type = 0;
        } else if (GL.getCapabilities().GL_ARB_framebuffer_object) {
            fbo = ARBFramebufferObject.glGenFramebuffers();
            this.type = 1;
        } else if (GL.getCapabilities().GL_EXT_framebuffer_object) {
            fbo = EXTFramebufferObject.glGenFramebuffersEXT();
            this.type = 2;
        }
        return fbo;
    }

    public int genRenderbuffers() {
        int rbo = -1;
        switch (this.type) {
            case 0: {
                rbo = GL30.glGenRenderbuffers();
                break;
            }
            case 1: {
                rbo = ARBFramebufferObject.glGenRenderbuffers();
                break;
            }
            case 2: {
                rbo = EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return rbo;
    }

    public void destroyBuffers() {
        this.unbindRead();
        this.unbindWrite();
        if (this.depthBuffer > -1) {
            this.deleteRenderbuffers(this.depthBuffer);
            this.depthBuffer = -1;
        }
        if (this.framebufferTexture > -1) {
            TextureUtil.releaseTextureId((int)this.framebufferTexture);
            this.framebufferTexture = -1;
        }
        if (this.frameBufferId > -1) {
            ImprovedFramebuffer.bindFramebuffer(this.type, 36160, 0);
            this.deleteFramebuffers(this.frameBufferId);
            this.frameBufferId = -1;
        }
    }

    private void deleteFramebuffers(int framebufferIn) {
        switch (this.type) {
            case 0: {
                GL30.glDeleteFramebuffers((int)framebufferIn);
                break;
            }
            case 1: {
                ARBFramebufferObject.glDeleteFramebuffers((int)framebufferIn);
                break;
            }
            case 2: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebufferIn);
            }
        }
    }

    private void deleteRenderbuffers(int renderbuffer) {
        switch (this.type) {
            case 0: {
                GL30.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
            }
        }
    }

    public void checkStatus() {
        int i = this.checkFramebufferStatus(36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    private int checkFramebufferStatus(int target) {
        switch (this.type) {
            case 0: {
                return GL30.glCheckFramebufferStatus((int)target);
            }
            case 1: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)target);
            }
            case 2: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
            }
        }
        return -1;
    }

    public static void bindFramebuffer(int type, int target, int framebufferIn) {
        if (framebufferIn == -1) {
            framebufferIn = 0;
        }
        switch (type) {
            case 0: {
                GL30.glBindFramebuffer((int)target, (int)framebufferIn);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebufferIn);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebufferIn);
            }
        }
    }

    public static void bindDefaultFramebuffer(int type, int target, Minecraft mc) {
        ImprovedFramebuffer.restoreMainRenderTarget();
        ImprovedFramebuffer.bindFramebuffer(type, target, mc.getMainRenderTarget().frameBufferId);
    }

    public static void framebufferTexture2D(int type, int target, int attachment, int textarget, int texture, int level) {
        switch (type) {
            case 0: {
                GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
            }
        }
    }

    public static void bindRenderbuffer(int type, int target, int renderbuffer) {
        switch (type) {
            case 0: {
                GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
            }
        }
    }

    public static void renderbufferStorage(int type, int target, int internalFormat, int width, int height) {
        switch (type) {
            case 0: {
                GL30.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                break;
            }
            case 1: {
                ARBFramebufferObject.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                break;
            }
            case 2: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalFormat, (int)width, (int)height);
            }
        }
    }

    public static void framebufferRenderbuffer(int type, int target, int attachment, int renderBufferTarget, int renderBuffer) {
        switch (type) {
            case 0: {
                GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
            }
        }
    }

    public void bindWrite(boolean p_147610_1_) {
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, this.frameBufferId);
        if (p_147610_1_) {
            GlStateManager._viewport((int)0, (int)0, (int)this.viewWidth, (int)this.viewHeight);
        }
    }

    public void unbindWrite() {
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, 0);
    }

    public void bindRead() {
        GlStateManager._bindTexture((int)this.framebufferTexture);
    }

    public void unbindRead() {
        GlStateManager._bindTexture((int)0);
    }

    public void setFilterMode(int framebufferFilterIn) {
        this.filterMode = framebufferFilterIn;
        GlStateManager._bindTexture((int)this.framebufferTexture);
        GlStateManager._texParameter((int)3553, (int)10241, (int)framebufferFilterIn);
        GlStateManager._texParameter((int)3553, (int)10240, (int)framebufferFilterIn);
        GlStateManager._texParameter((int)3553, (int)10242, (int)10496);
        GlStateManager._texParameter((int)3553, (int)10243, (int)10496);
        GlStateManager._bindTexture((int)0);
    }

    public int getFramebufferTexture() {
        return this.framebufferTexture;
    }

    public void setFramebufferTexture(int textureId) {
        if (textureId != this.framebufferTexture) {
            this.framebufferTexture = textureId;
            if (textureId != 0) {
                ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.framebufferTexture, 0);
            }
        }
    }

    public void generateMipmaps() {
        switch (this.type) {
            case 0: {
                GL30.glGenerateMipmap((int)3553);
                break;
            }
            case 1: {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
                break;
            }
            case 2: {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    private void forceAsMainRenderTarget() {
        if (mainRenderTargetBackup == null) {
            mainRenderTargetBackup = (Framebuffer)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD);
        }
        ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)((Object)this));
    }

    public static void restoreMainRenderTarget() {
        if (mainRenderTargetBackup != null) {
            ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)mainRenderTargetBackup);
        }
    }

    public void bindAsMainTarget(boolean viewport) {
        this.bindWrite(viewport);
        this.forceAsMainRenderTarget();
    }
}

