/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.Config;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.gui.GuiMap;
import xaero.map.gui.TooltipButton;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private Widget caveModeStartSlider;
    private TextFieldWidget caveModeStartField;
    private boolean shouldUpdateSlider;

    public void onInit(GuiMap screen, MapProcessor mapProcessor) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = mapProcessor.getMapWorld().getFutureDimension();
        boolean bl = this.enabled = this.enabled && this.dimension != null && WorldMapClientConfigUtils.getEffectiveCaveModeAllowed();
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            Tooltip caveModeTypeButtonTooltip = new Tooltip("gui.xaero_wm_box_cave_mode_type");
            screen.addButton(new TooltipButton(20, screen.height - 62, 150, 20, this.getCaveModeTypeButtonMessage(), b -> this.onCaveModeTypeButton(b, screen), () -> caveModeTypeButtonTooltip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(Button b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.setMessage(this.getCaveModeTypeButtonMessage());
    }

    private TextFieldWidget createField(GuiMap screen) {
        TextFieldWidget field = new TextFieldWidget(Minecraft.getInstance().font, 172, screen.height - 40, 50, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_cave_mode_start"));
        field.setMaxLength(7);
        int initialCaveModeStart = this.getCaveStart();
        field.setValue(initialCaveModeStart == Integer.MAX_VALUE ? "" : initialCaveModeStart + "");
        field.setResponder(text -> {
            try {
                this.setCaveStart(text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text));
                this.shouldUpdateSlider = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        return field;
    }

    private int getCaveStart() {
        Config primaryConfig = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager().getConfig();
        return (Integer)primaryConfig.get(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START);
    }

    private void setCaveStart(int y) {
        Config primaryConfig = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager().getConfig();
        primaryConfig.set(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START, (Object)y);
        WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManagerIO().save();
    }

    private Widget createSlider(GuiMap screen) {
        TranslationTextComponent displayName = new TranslationTextComponent("gui.xaero_wm_cave_mode_start");
        Supplier<ITextComponent> labelGetter = () -> GuiCaveModeOptions.lambda$createSlider$3((ITextComponent)displayName);
        int initialCaveStart = this.getCaveStart();
        int minY = -64;
        int maxY = 319;
        int minOption = minY - 1;
        int range = maxY - minOption;
        double initialSliderValue = MathHelper.clamp((double)((double)(initialCaveStart - minOption) / (double)range), (double)0.0, (double)1.0);
        return new XaeroSliderWidget(20, screen.height - 40, 150, 20, labelGetter.get(), initialSliderValue, newSliderValue -> {
            int selectedY = (int)Math.round(newSliderValue * (double)range) + minOption;
            if (selectedY == minOption) {
                selectedY = Integer.MAX_VALUE;
            }
            this.setCaveStart(selectedY);
            screen.onCaveModeStartSet();
        }, labelGetter);
    }

    private void updateField(GuiMap screen) {
        if (this.caveModeStartField == null) {
            this.caveModeStartField = this.createField(screen);
            screen.addButton(this.caveModeStartField);
        } else {
            this.caveModeStartField = this.createField(screen);
            screen.replaceWidget((Widget)this.caveModeStartField, (Widget)this.caveModeStartField);
        }
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.addButton(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMapClientConfigUtils.getEffectiveCaveModeAllowed() && !this.enabled;
        screen.init(Minecraft.getInstance(), screen.width, screen.height);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.shouldUpdateSlider) {
            this.updateSlider(screen);
            this.shouldUpdateSlider = false;
        }
        if (this.enabled) {
            this.caveModeStartField.setSuggestion(this.caveModeStartField.getValue().isEmpty() ? I18n.get((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]) : "");
            this.caveModeStartField.tick();
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.setFocus(false);
        }
        if (this.caveModeStartSlider != null && this.caveModeStartSlider.isFocused()) {
            this.caveModeStartSlider.changeFocus(true);
        }
    }

    private ITextComponent getCaveModeTypeButtonMessage() {
        return new StringTextComponent(I18n.get((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.get((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0]));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static /* synthetic */ ITextComponent lambda$createSlider$3(ITextComponent displayName) {
        return displayName;
    }
}

