/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.world.MapDimension;

public class GuiMapName
extends ScreenBase {
    private TextFieldWidget nameTextField;
    private MapDimension mapDimension;
    private String editingMWId;
    private String currentNameFieldContent;
    private MapProcessor mapProcessor;

    public GuiMapName(MapProcessor mapProcessor, Screen par1GuiScreen, Screen escape, MapDimension mapDimension, String editingMWId) {
        super(par1GuiScreen, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_map_name"));
        this.mapDimension = mapDimension;
        this.editingMWId = editingMWId;
        this.currentNameFieldContent = editingMWId == null ? "" : mapDimension.getMultiworldName(editingMWId);
        this.mapProcessor = mapProcessor;
        this.canSkipWorldRender = true;
    }

    public void init() {
        super.init();
        if (this.nameTextField != null) {
            this.currentNameFieldContent = this.nameTextField.getValue();
        }
        this.nameTextField = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_map_name"));
        this.nameTextField.setValue(this.currentNameFieldContent);
        this.setFocused((IGuiEventListener)this.nameTextField);
        this.nameTextField.setFocus(true);
        this.children.add(this.nameTextField);
        this.addButton((Widget)new MySmallButton(0, this.width / 2 - 155, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            if (this.canConfirm()) {
                Object object = this.mapProcessor.uiSync;
                synchronized (object) {
                    if (this.mapProcessor.getMapWorld() == this.mapDimension.getMapWorld()) {
                        String mwIdFixed;
                        String unfilteredName = this.nameTextField.getValue();
                        if (this.editingMWId == null) {
                            String mwId = unfilteredName.toLowerCase().replaceAll("[^a-z0-9]+", "");
                            if (mwId.isEmpty()) {
                                mwId = "map";
                            }
                            mwId = "cm$" + mwId;
                            boolean mwAdded = false;
                            mwIdFixed = mwId;
                            int fix = 1;
                            while (!mwAdded) {
                                mwAdded = this.mapDimension.addMultiworldChecked(mwIdFixed);
                                if (mwAdded) continue;
                                mwIdFixed = mwId + ++fix;
                            }
                            Path dimensionFolderPath = this.mapDimension.getMainFolderPath();
                            Path multiworldFolderPath = dimensionFolderPath.resolve(mwIdFixed);
                            try {
                                Files.createDirectories(multiworldFolderPath, new FileAttribute[0]);
                            }
                            catch (IOException e) {
                                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                            }
                            this.mapDimension.setMultiworldUnsynced(mwIdFixed);
                        } else {
                            mwIdFixed = this.editingMWId;
                        }
                        this.mapDimension.setMultiworldName(mwIdFixed, unfilteredName);
                        this.mapDimension.saveConfigUnsynced();
                        this.goBack();
                    }
                }
            }
        }));
        this.addButton((Widget)new MySmallButton(1, this.width / 2 + 5, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.updateConfirmButton();
    }

    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    private boolean canConfirm() {
        return this.nameTextField.getValue().length() > 0;
    }

    private void updateConfirmButton() {
        ((Button)this.buttons.get((int)0)).active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void tick() {
        this.updateConfirmButton();
        this.nameTextField.tick();
    }

    public void render(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        this.renderBackground(matrixStack);
        GuiMapName.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.font, (ITextComponent)this.title, (int)(this.width / 2), (int)20, (int)0xFFFFFF);
        this.nameTextField.render(matrixStack, par1, par2, par3);
        super.render(matrixStack, par1, par2, par3);
    }
}

