/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;
import xaero.map.graphics.MapRenderHelper;

public class PlayerTrackerIconRenderer {
    public void renderIcon(MatrixStack matrixStack, PlayerEntity player, ResourceLocation skinTextureLocation) {
        boolean upsideDown = player != null && player.isModelPartShown(PlayerModelPart.CAPE) && ("Dinnerbone".equals(player.getGameProfile().getName()) || "Grumm".equals(player.getGameProfile().getName()));
        int textureY = 8 + (upsideDown ? 8 : 0);
        int textureH = 8 * (upsideDown ? -1 : 1);
        Minecraft.getInstance().getTextureManager().bind(skinTextureLocation);
        BufferBuilder bufferbuilder = Tessellator.getInstance().getBuilder();
        bufferbuilder.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.last().pose(), (IVertexBuilder)bufferbuilder, -4, -4, 8, textureY, 8, 8, 8, textureH, 1.0f, 1.0f, 1.0f, 1.0f, 64, 64);
        if (player != null && player.isModelPartShown(PlayerModelPart.HAT)) {
            textureY = 8 + (upsideDown ? 8 : 0);
            textureH = 8 * (upsideDown ? -1 : 1);
            MapRenderHelper.blitIntoExistingBuffer(matrixStack.last().pose(), (IVertexBuilder)bufferbuilder, -4, -4, 40, textureY, 8, 8, 8, textureH, 1.0f, 1.0f, 1.0f, 1.0f, 64, 64);
        }
        RenderSystem.enableAlphaTest();
        bufferbuilder.end();
        WorldVertexBufferUploader.end((BufferBuilder)bufferbuilder);
    }
}

