/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;

public class TrackedPlayerIconPrerenderer {
    private ImprovedFramebuffer renderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private MatrixStack matrixStack = new MatrixStack();
    private final PlayerTrackerIconRenderer renderer = new PlayerTrackerIconRenderer();

    public void prerender(XaeroIcon icon, PlayerEntity player, int iconWidth, ResourceLocation skinTextureLocation, PlayerTrackerMapElement<?> mapElement) {
        if (this.renderFramebuffer == null) {
            this.renderFramebuffer = new ImprovedFramebuffer(icon.getTextureAtlas().getWidth(), icon.getTextureAtlas().getWidth(), false);
            GlStateManager._deleteTexture((int)this.renderFramebuffer.getColorTextureId());
            this.renderFramebuffer.setFramebufferTexture(0);
        }
        this.renderFramebuffer.bindAsMainTarget(false);
        GlStateManager._viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)iconWidth, (int)iconWidth);
        this.renderFramebuffer.setFramebufferTexture(icon.getTextureAtlas().getTextureId());
        this.renderFramebuffer.checkStatus();
        if (this.lastAtlas != icon.getTextureAtlas()) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)Minecraft.ON_OSX);
            this.lastAtlas = icon.getTextureAtlas();
        }
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)iconWidth, (double)iconWidth, (double)0.0, (double)-1.0, (double)1000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        MatrixStack matrixStack = this.matrixStack;
        matrixStack.pushPose();
        matrixStack.translate((double)(iconWidth / 2), (double)(iconWidth / 2), 0.0);
        matrixStack.scale(3.0f, 3.0f, 1.0f);
        AbstractGui.fill((MatrixStack)matrixStack, (int)-5, (int)-5, (int)5, (int)5, (int)-1);
        this.renderer.renderIcon(matrixStack, player, skinTextureLocation);
        matrixStack.popPose();
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.matrixMode((int)5889);
        Misc.minecraftOrtho(mc, false);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        this.renderFramebuffer.unbindWrite();
        ImprovedFramebuffer.bindDefaultFramebuffer(this.renderFramebuffer.getType(), 36160, mc);
        GlStateManager._viewport((int)0, (int)0, (int)mc.getWindow().getWidth(), (int)mc.getWindow().getHeight());
    }
}

