/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO = new ImprovedFramebuffer(64, 64, false);
    private int glEmptyTexture = this.renderFBO.getFramebufferTexture();

    public BranchTextureRenderer(Framebuffer defaultFramebuffer) {
        this.renderFBO.bindWrite(true);
        GlStateManager._disableAlphaTest();
        GlStateManager._disableBlend();
        GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager._clear((int)16384, (boolean)Minecraft.ON_OSX);
        GlStateManager._enableAlphaTest();
        GlStateManager._enableBlend();
        this.renderFBO.unbindWrite();
        ImprovedFramebuffer.bindFramebuffer(this.renderFBO.getType(), 36160, defaultFramebuffer.frameBufferId);
        GlStateManager._viewport((int)0, (int)0, (int)defaultFramebuffer.viewWidth, (int)defaultFramebuffer.viewHeight);
    }

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, Framebuffer defaultFramebuffer, boolean justAllocated) {
        GlStateManager._bindTexture((int)0);
        this.renderFBO.bindAsMainTarget(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        GlStateManager._pushMatrix();
        GlStateManager._loadIdentity();
        GlStateManager._matrixMode((int)5889);
        GlStateManager._loadIdentity();
        GlStateManager._ortho((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1.0);
        GlStateManager._matrixMode((int)5888);
        GlStateManager._disableAlphaTest();
        GlStateManager._disableBlend();
        if (justAllocated) {
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager._clear((int)16384, (boolean)Minecraft.ON_OSX);
        }
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1);
        }
        OpenGLException.checkGLError(false, "updating a map branch texture");
        GlStateManager._enableAlphaTest();
        GlStateManager._enableBlend();
        GlStateManager._bindTexture((int)0);
        GlStateManager._popMatrix();
        GlStateManager._matrixMode((int)5889);
        Minecraft mc = Minecraft.getInstance();
        Misc.minecraftOrtho(mc, false);
        GlStateManager._matrixMode((int)5888);
        this.renderFBO.unbindWrite();
        ImprovedFramebuffer.bindDefaultFramebuffer(this.renderFBO.getType(), 36160, mc);
        GlStateManager._viewport((int)0, (int)0, (int)mc.getWindow().getWidth(), (int)mc.getWindow().getHeight());
        OpenGLException.checkGLError();
    }

    private void renderCorner(Integer srcTexture, int cornerX, int cornerY) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        GlStateManager._bindTexture((int)(srcTexture != -1 ? srcTexture : this.glEmptyTexture));
        MapRenderHelper.renderTexturedModalRect(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f);
    }
}

