/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.teleport;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapTeleporter {
    public void teleport(Screen screen, MapWorld mapWorld, int x, int y, int z, RegistryKey<World> d) {
        String tpCommand;
        Minecraft.getInstance().setScreen(null);
        if (Minecraft.getInstance().gameMode.canHurtPlayer()) {
            MapConnectionNode destinationMapKey;
            MapDimension destinationDim = mapWorld.getDimension(d != null ? d : Minecraft.getInstance().level.dimension());
            MapConnectionNode playerMapKey = mapWorld.getPlayerMapKey();
            if (playerMapKey == null) {
                StringTextComponent messageComponent = new StringTextComponent(I18n.get((String)"gui.xaero_wm_teleport_never_confirmed", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().withColor(TextFormatting.RED));
                Minecraft.getInstance().gui.getChat().addMessage((ITextComponent)messageComponent);
                return;
            }
            MapConnectionNode mapConnectionNode = destinationMapKey = destinationDim == null ? null : destinationDim.getSelectedMapKeyUnsynced();
            if (!mapWorld.getMapConnections().isConnected(playerMapKey, destinationMapKey)) {
                StringTextComponent messageComponent = new StringTextComponent(I18n.get((String)"gui.xaero_wm_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().withColor(TextFormatting.RED));
                Minecraft.getInstance().gui.getChat().addMessage((ITextComponent)messageComponent);
                return;
            }
        }
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean partialYTeleportConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.PARTIAL_Y_TELEPORT);
        String string = tpCommand = d == null ? mapWorld.getEffectiveTeleportCommandFormat() : mapWorld.getEffectiveDimensionTeleportCommandFormat();
        String yString = y == -1 ? "~" : (partialYTeleportConfig ? (double)y + 0.5 + "" : y + "");
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z);
        if (d != null) {
            tpCommand = tpCommand.replace("{d}", d.location().toString());
        }
        screen.sendMessage(tpCommand, false);
        mapWorld.setCustomDimensionId(null);
        mapWorld.getMapProcessor().checkForWorldUpdate();
    }
}

