/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;
    private Button renderWaypointsButton;
    private Button showDisabledButton;
    private Button closeMenuWhenHoppingButton;
    private Button currentMapWaypointsButton;
    private Button renderAllSetsButton;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height, WaypointWorld waypointWorld, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        DropDownWidget setsDropdown;
        super.onMapInit(screen, mc, width, height);
        boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
        GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
        IDropDownWidgetCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = (menu, selected) -> {
                if (canCreate && selected == menu.size() - 1) {
                    GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (Screen)screen, (Screen)screen, waypointWorld);
                    Minecraft.func_71410_x().func_147108_a((Screen)guiNewSet);
                    return false;
                }
                sets.setCurrentSet(selected);
                waypointWorld.setCurrent(sets.getCurrentSetKey());
                minimapSession.getWaypointsManager().updateWaypoints();
                try {
                    modMain.getSettings().saveWaypoints(waypointWorld);
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
                return true;
            };
        }
        DropDownWidget dropDownWidget = setsDropdown = sets == null ? null : DropDownWidget.Builder.begin().setOptions(sets.getOptions()).setX(width - 173).setY(height - 56).setW(151).setSelected(Integer.valueOf(sets.getCurrentSet())).setCallback(setsDropdownCallback).setContainer((IDropDownContainer)screen).setOpeningUp(true).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_waypoint_set")).build();
        if (setsDropdown != null) {
            screen.func_230481_d_(setsDropdown);
        }
        TranslationTextComponent fullWaypointMenuTooltipText = new TranslationTextComponent("gui.xaero_box_full_waypoints_menu", new Object[]{new StringTextComponent(KeyMappingUtils.getKeyName((KeyBinding)ModSettings.keyWaypoints)).func_240699_a_(TextFormatting.DARK_GREEN)});
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean renderWaypoints = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean onlyCurrentMapWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        boolean showDisabledWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        boolean closeWaypointsWhenHopping = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        Tooltip fullWaypointMenuTooltip = new Tooltip((ITextComponent)fullWaypointMenuTooltipText, true);
        Tooltip onlyCurrentMapWaypointsTooltip = new Tooltip(onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", Style.field_240709_b_, true);
        Tooltip renderingWaypointsTooltip = new Tooltip((ITextComponent)new TranslationTextComponent(renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints", new Object[]{new StringTextComponent(KeyMappingUtils.getKeyName((KeyBinding)ModSettings.keyToggleMapWaypoints)).func_240699_a_(TextFormatting.DARK_GREEN)}), true);
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean renderAllSetsConfig = (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ALL_SETS);
        Tooltip renderAllSetsTooltip = new Tooltip((ITextComponent)new TranslationTextComponent(!renderAllSetsConfig ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets", new Object[]{new StringTextComponent(KeyMappingUtils.getKeyName((KeyBinding)ModSettings.keyAllSets)).func_240699_a_(TextFormatting.DARK_GREEN)}), true);
        Tooltip showingDisabledTooltip = new Tooltip(showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", Style.field_240709_b_, true);
        Tooltip closeWhenHoppingTooltip = new Tooltip(closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", Style.field_240709_b_, true);
        screen.func_230480_a_(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, b -> this.onFullMenuButton(b, screen), () -> fullWaypointMenuTooltip));
        this.currentMapWaypointsButton = new GuiTexturedButton(width - 153, height - 20, 20, 20, onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, b -> this.onCurrentMapWaypointsButton(b, screen, width, height), () -> onlyCurrentMapWaypointsTooltip);
        screen.func_230480_a_(this.currentMapWaypointsButton);
        this.renderWaypointsButton = new GuiTexturedButton(width - 133, height - 20, 20, 20, renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onRenderWaypointsButton(screen, width, height), () -> renderingWaypointsTooltip);
        screen.func_230480_a_(this.renderWaypointsButton);
        this.renderAllSetsButton = new GuiTexturedButton(width - 113, height - 20, 20, 20, !renderAllSetsConfig ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, b -> this.onRenderAllSetsButton(b, screen, width, height), () -> renderAllSetsTooltip);
        screen.func_230480_a_(this.renderAllSetsButton);
        this.showDisabledButton = new GuiTexturedButton(width - 93, height - 20, 20, 20, showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, b -> this.onShowDisabledButton(b, screen, width, height), () -> showingDisabledTooltip);
        screen.func_230480_a_(this.showDisabledButton);
        this.closeMenuWhenHoppingButton = new GuiTexturedButton(width - 73, height - 20, 20, 20, closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, b -> this.onCloseMenuWhenHoppingButton(b, screen, width, height), () -> closeWhenHoppingTooltip);
        screen.func_230480_a_(this.closeMenuWhenHoppingButton);
        this.renderWaypointsButton.field_230693_o_ = !WorldMapClientConfigUtils.isOptionServerEnforced((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        screen.func_231158_b_(this.mc, width, height);
        screen.func_231035_a_((IGuiEventListener)this.renderWaypointsButton);
    }

    private void onFullMenuButton(Button b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(Button b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
        screen.func_231035_a_((IGuiEventListener)this.renderAllSetsButton);
    }

    private void onShowDisabledButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        screen.func_231158_b_(this.mc, width, height);
        screen.func_231035_a_((IGuiEventListener)this.showDisabledButton);
    }

    private void onCloseMenuWhenHoppingButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        screen.func_231158_b_(this.mc, width, height);
        screen.func_231035_a_((IGuiEventListener)this.closeMenuWhenHoppingButton);
    }

    private void onCurrentMapWaypointsButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        screen.func_231158_b_(this.mc, width, height);
        screen.func_231035_a_((IGuiEventListener)this.currentMapWaypointsButton);
    }

    @Override
    public void renderInMenu(Waypoint element, MatrixStack matrixStack, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        matrixStack.func_227861_a_(-4.0, -4.0, 0.0);
        RenderSystem.enableBlend();
        if (type == 1) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)color);
            Texture texture = mc.func_110434_K().func_229267_b_(Waypoint.minimapTextures);
            texture.func_174937_a(false, false);
            texture.func_229148_d_();
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 1, 1, 0, 78, 9, 9);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 0, 0, 0, 78, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.disableTexture();
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)color);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type != 1) {
            mc.field_71466_p.func_238405_a_(matrixStack, symbol, (float)(5 - mc.field_71466_p.func_78256_a(symbol) / 2), 1.0f, -1);
        }
        RenderSystem.enableBlend();
        int infoIconOffset = 10;
        if (disabled) {
            RenderSystem.enableTexture();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_238474_b_(matrixStack, textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += 10;
        }
        if (temporary) {
            RenderSystem.enableTexture();
            RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_238474_b_(matrixStack, textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += 10;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected ElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

