/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class BiomeBlendCalculator
implements IBlockDisplayReader {
    private World original;

    public void setWorld(World original) {
        this.original = original;
    }

    public TileEntity getBlockEntity(BlockPos blockPos) {
        return this.original.getBlockEntity(blockPos);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return this.original.getBlockState(blockPos);
    }

    public FluidState getFluidState(BlockPos blockPos) {
        return this.original.getFluidState(blockPos);
    }

    public float getShade(Direction direction, boolean bl) {
        return this.original.getShade(direction, bl);
    }

    public WorldLightManager getLightEngine() {
        return this.original.getLightEngine();
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        int redAccumulator = 0;
        int greenAccumulator = 0;
        int blueAccumulator = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                mutableBlockPos.set(x + i, y, z + j);
                Biome biome = this.original.getBiome((BlockPos)mutableBlockPos);
                int colorSample = colorResolver.getColor(biome, (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
                redAccumulator += colorSample >> 16 & 0xFF;
                greenAccumulator += colorSample >> 8 & 0xFF;
                blueAccumulator += colorSample & 0xFF;
            }
        }
        int red = redAccumulator / 9;
        int green = greenAccumulator / 9;
        int blue = blueAccumulator / 9;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

