/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;

public class WorldDataChunkTileEntityLookup {
    private ListNBT tileEntitiesNbt;
    private Int2ObjectMap<Int2ObjectMap<Int2ObjectMap<CompoundNBT>>> tileEntities;

    public WorldDataChunkTileEntityLookup(ListNBT tileEntitiesNbt) {
        this.tileEntitiesNbt = tileEntitiesNbt;
    }

    private void loadIfNeeded() {
        if (this.tileEntities == null) {
            this.tileEntities = new Int2ObjectOpenHashMap();
            this.tileEntitiesNbt.forEach(tag -> {
                if (tag instanceof CompoundNBT) {
                    Int2ObjectMap byY;
                    CompoundNBT compoundNbt = (CompoundNBT)tag;
                    if (!compoundNbt.contains("x", 99)) {
                        return;
                    }
                    int x = compoundNbt.getInt("x") & 0xF;
                    if (!compoundNbt.contains("y", 99)) {
                        return;
                    }
                    int y = compoundNbt.getInt("y");
                    if (!compoundNbt.contains("z", 99)) {
                        return;
                    }
                    int z = compoundNbt.getInt("z") & 0xF;
                    Int2ObjectMap byX = (Int2ObjectMap)this.tileEntities.get(x);
                    if (byX == null) {
                        byX = new Int2ObjectOpenHashMap();
                        this.tileEntities.put(x, (Object)byX);
                    }
                    if ((byY = (Int2ObjectMap)byX.get(y)) == null) {
                        byY = new Int2ObjectOpenHashMap();
                        byX.put(y, (Object)byY);
                    }
                    byY.put(z, (Object)compoundNbt);
                }
            });
            this.tileEntitiesNbt = null;
        }
    }

    public CompoundNBT getTileEntityNbt(int x, int y, int z) {
        this.loadIfNeeded();
        Int2ObjectMap byX = (Int2ObjectMap)this.tileEntities.get(x);
        if (byX == null) {
            return null;
        }
        Int2ObjectMap byY = (Int2ObjectMap)byX.get(y);
        if (byY == null) {
            return null;
        }
        return (CompoundNBT)byY.get(z);
    }
}

