/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.util.LazyOptional;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.capabilities.ServerWorldLoaded;
import xaero.map.executor.Executor;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;
import xaero.map.world.MapWorld;

public class WorldDataHandler {
    private final Executor renderExecutor;
    private WorldDataReader reader;
    private ServerWorld worldServer;
    private File worldDir;

    public WorldDataHandler(WorldDataReader reader, Executor renderExecutor) {
        this.reader = reader;
        this.renderExecutor = renderExecutor;
    }

    public void handleRenderExecutor() {
        this.renderExecutor.runAllTasks();
    }

    public void prepareSingleplayer(World world, MapProcessor mapProcessor) {
        MapWorld mapWorld = mapProcessor.getMapWorld();
        if (world != null && mapWorld.getCurrentDimension().isUsingWorldSave()) {
            RegistryKey<World> dimId = mapWorld.getCurrentDimensionId();
            this.worldServer = Minecraft.getInstance().getSingleplayerServer().getLevel(dimId);
            if (this.worldServer != null) {
                File overworldDir = this.worldServer.getServer().getWorldPath(FolderName.ROOT).toFile();
                this.worldDir = DimensionType.getStorageFolder(dimId, (File)overworldDir);
            } else {
                this.worldDir = null;
            }
        } else {
            this.worldServer = null;
            this.worldDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildRegion(MapRegion region, boolean loading, int[] chunkCountDest) throws IOException {
        if (this.worldServer == null) {
            WorldMap.LOGGER.info("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        LazyOptional capabilityValue = this.worldServer.getCapability(ServerWorldCapabilities.LOADED_CAP);
        if (capabilityValue.isPresent()) {
            ServerWorldLoaded loadedCap = (ServerWorldLoaded)capabilityValue.orElse(null);
            boolean shouldCancel = false;
            ServerWorldLoaded serverWorldLoaded = loadedCap;
            synchronized (serverWorldLoaded) {
                if (loadedCap.loaded) {
                    boolean buildResult = this.reader.buildRegion(region, this.worldServer, loading, chunkCountDest, this.renderExecutor);
                    Result result = buildResult ? Result.SUCCESS : Result.FAIL;
                    return result;
                }
                shouldCancel = true;
            }
            if (shouldCancel) {
                WorldMap.LOGGER.info("Tried loading a region for an unloaded server world!");
                return Result.CANCEL;
            }
        }
        WorldMap.LOGGER.info("Server world capability required for Xaero's World Map not present!");
        return Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerWorldUnload(ServerWorld sw) {
        LazyOptional capabilityValue = sw.getCapability(ServerWorldCapabilities.LOADED_CAP);
        if (capabilityValue.isPresent()) {
            ServerWorldLoaded loadedCap;
            ServerWorldLoaded serverWorldLoaded = loadedCap = (ServerWorldLoaded)capabilityValue.orElse(null);
            synchronized (serverWorldLoaded) {
                loadedCap.loaded = false;
            }
        }
    }

    public ServerWorld getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.reader;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    Executor getWorldDataRenderExecutor() {
        return this.renderExecutor;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

