/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;

public class MapRenderHelper {
    public static void renderTexturedModalRect(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.vertex((double)(x + 0.0f), (double)(y + height), 0.0).uv(normalizedTextureX, normalizedTextureY2).endVertex();
        vertexBuffer.vertex((double)(x + width), (double)(y + height), 0.0).uv(normalizedTextureX2, normalizedTextureY2).endVertex();
        vertexBuffer.vertex((double)(x + width), (double)(y + 0.0f), 0.0).uv(normalizedTextureX2, normalizedTextureY).endVertex();
        vertexBuffer.vertex((double)(x + 0.0f), (double)(y + 0.0f), 0.0).uv(normalizedTextureX, normalizedTextureY).endVertex();
        tessellator.end();
    }

    public static void fillIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        bufferBuilder.vertex(matrix, (float)x1, (float)y2, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex(matrix, (float)x2, (float)y2, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex(matrix, (float)x2, (float)y1, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex(matrix, (float)x1, (float)y1, 0.0f).color(r, g, b, a).endVertex();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, width, height, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x, int y, int u, int v, int width, int height, int uW, int vH, float r, float g, float b, float a, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + uW) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + vH) * factorY;
        bufferBuilder.vertex(matrix, (float)x, (float)(y + height), 0.0f).uv(textureX1, textureY2).color(r, g, b, a).endVertex();
        bufferBuilder.vertex(matrix, (float)(x + width), (float)(y + height), 0.0f).uv(textureX2, textureY2).color(r, g, b, a).endVertex();
        bufferBuilder.vertex(matrix, (float)(x + width), (float)y, 0.0f).uv(textureX2, textureY1).color(r, g, b, a).endVertex();
        bufferBuilder.vertex(matrix, (float)x, (float)y, 0.0f).uv(textureX1, textureY1).color(r, g, b, a).endVertex();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, r, g, b, a, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (IVertexBuilder)bufferBuilder, x, y, u, v, width, height, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int uW, int vH, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (IVertexBuilder)bufferBuilder, x, y, u, v, width, height, uW, vH, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, r, g, b, a, 256, 256, texture);
    }

    public static void renderDynamicHighlight(MatrixStack matrixStack, IVertexBuilder overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - 1 - flooredCameraX, topZ - 1 - flooredCameraZ, leftX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX - flooredCameraX, topZ - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, rightX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX + 1 - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - flooredCameraX, bottomZ - flooredCameraZ, rightX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - flooredCameraX, topZ - flooredCameraZ, rightX - flooredCameraX, bottomZ - flooredCameraZ, centerR, centerG, centerB, centerA);
    }

    public static void drawCenteredStringWithBackground(MatrixStack matrixStack, FontRenderer font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, IVertexBuilder backgroundVertexBuffer) {
        int stringWidth = font.width(string);
        MapRenderHelper.drawStringWithBackground(matrixStack, font, string, x - stringWidth / 2, y, color, bgRed, bgGreen, bgBlue, bgAlpha, backgroundVertexBuffer);
    }

    public static void drawStringWithBackground(MatrixStack matrixStack, FontRenderer font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, IVertexBuilder backgroundVertexBuffer) {
        int stringWidth = font.width(string);
        matrixStack.translate(0.0, 0.0, -1.0);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), backgroundVertexBuffer, x - 1, y - 1, x + stringWidth + 1, y + 9, bgRed, bgGreen, bgBlue, bgAlpha);
        matrixStack.translate(0.0, 0.0, 1.0);
        AbstractGui.drawString((MatrixStack)matrixStack, (FontRenderer)font, (String)string, (int)x, (int)y, (int)color);
    }

    public static void drawCenteredStringWithBackground(MatrixStack matrixStack, FontRenderer font, ITextComponent text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, IVertexBuilder backgroundVertexBuffer) {
        int stringWidth = font.width((ITextProperties)text);
        MapRenderHelper.drawStringWithBackground(matrixStack, font, text, x - stringWidth / 2, y, color, bgRed, bgGreen, bgBlue, bgAlpha, backgroundVertexBuffer);
    }

    public static void drawStringWithBackground(MatrixStack matrixStack, FontRenderer font, ITextComponent text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, IVertexBuilder backgroundVertexBuffer) {
        int stringWidth = font.width((ITextProperties)text);
        matrixStack.translate(0.0, 0.0, -1.0);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), backgroundVertexBuffer, x - 1, y - 1, x + stringWidth + 1, y + 9, bgRed, bgGreen, bgBlue, bgAlpha);
        matrixStack.translate(0.0, 0.0, 1.0);
        AbstractGui.drawString((MatrixStack)matrixStack, (FontRenderer)font, (ITextComponent)text, (int)x, (int)y, (int)color);
    }
}

