/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.gui.ScreenBase;
import xaero.map.world.MapWorld;

public class GuiPlayerTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private TextFieldWidget commandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;

    public GuiPlayerTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_player_teleport_command"));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultPlayerTeleport();
        this.commandFormat = mapWorld.getPlayerTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void init() {
        super.init();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        String defaultPlayerTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_PLAYER_TELEPORT_FORMAT);
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.commandFormatTextField = new TextFieldWidget(this.font, this.width / 2 - 100, this.height / 7 + 60, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_player_teleport_command"));
        this.commandFormatTextField.setValue(this.usingDefault ? defaultPlayerTeleportFormat : this.commandFormat);
        this.commandFormatTextField.setMaxLength(500);
        if (this.usingDefault) {
            this.commandFormatTextField.setTextColor(-11184811);
            this.commandFormatTextField.active = false;
            this.commandFormatTextField.setEditable(false);
        } else {
            this.commandFormatTextField.setResponder(text -> {
                this.commandFormat = text;
            });
        }
        this.addWidget((IGuiEventListener)this.commandFormatTextField);
        this.confirmButton = new MySmallButton(0, this.width / 2 - 155, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            if (!this.canConfirm()) {
                return;
            }
            if (!this.usingDefault && this.commandFormat.equals(defaultPlayerTeleportFormat)) {
                this.usingDefault = true;
            }
            mapWorld.setUseDefaultPlayerTeleport(this.usingDefault);
            mapWorld.setPlayerTeleportCommandFormat(this.commandFormat);
            mapWorld.saveConfig();
            this.goBack();
        });
        this.addButton((Widget)this.confirmButton);
        this.addButton((Widget)new MySmallButton(1, this.width / 2 + 5, this.height / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
        this.addButton((Widget)new MySmallButton(202, this.width / 2 - 75, this.height / 7 + 20, ConfigUtils.optionNameValue((ITextComponent)new TranslationTextComponent("gui.xaero_wm_use_default"), (ITextComponent)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault)), b -> {
            this.usingDefault = !this.usingDefault;
            this.init(this.minecraft, this.width, this.height);
        }));
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(matrixStack, mouseX, mouseY, partial);
        this.renderBackground(matrixStack);
        AbstractGui.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.font, (ITextComponent)this.title, (int)(this.width / 2), (int)20, (int)0xFFFFFF);
        AbstractGui.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.font, (String)"{x} {y} {z} {name}", (int)(this.width / 2), (int)(this.height / 7 + 46), (int)-5592406);
        super.render(matrixStack, mouseX, mouseY, partial);
        this.commandFormatTextField.render(matrixStack, mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0;
    }

    public void tick() {
        super.tick();
        this.commandFormatTextField.tick();
        this.confirmButton.active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.onClick(0.0, 0.0);
        }
        return super.keyPressed(par1, par2, par3);
    }

    public void setFocused(IGuiEventListener l) {
        IGuiEventListener currentFocused = this.getFocused();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof TextFieldWidget) {
            ((TextFieldWidget)currentFocused).setFocus(false);
        }
        super.setFocused(l);
    }
}

