/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import xaero.lib.common.util.TextSplitter;
import xaero.map.gui.message.Message;

public class MessageBox {
    private final List<Message> messages;
    private final int width;
    private final int capacity;

    private MessageBox(List<Message> messages, int width, int capacity) {
        this.messages = messages;
        this.width = width;
        this.capacity = capacity;
    }

    private void addMessageLine(ITextComponent text) {
        Message msg = new Message(text, System.currentTimeMillis());
        this.messages.add(0, msg);
        if (this.messages.size() > this.capacity) {
            this.messages.remove(this.messages.size() - 1);
        }
    }

    public void addMessage(ITextComponent text) {
        ArrayList splitDest = new ArrayList();
        TextSplitter.splitTextIntoLines(splitDest, (int)this.width, (int)this.width, (ITextProperties)text, null);
        for (ITextComponent line : splitDest) {
            this.addMessageLine(line);
        }
    }

    public void addMessageWithSource(ITextComponent source, ITextComponent text) {
        StringTextComponent fullText = new StringTextComponent("<");
        fullText.getSiblings().add(source);
        fullText.getSiblings().add(new StringTextComponent("> "));
        fullText.getSiblings().add(text);
        this.addMessage((ITextComponent)fullText);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Iterator<Message> getIterator() {
        return this.messages.iterator();
    }

    public static class Builder {
        private int width;
        private int capacity;

        private Builder() {
        }

        public Builder setDefault() {
            this.setWidth(250);
            this.setCapacity(5);
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public MessageBox build() {
            return new MessageBox(new ArrayList(this.capacity), this.width, this.capacity);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

